/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.utils.menu;

import dev.lrxh.neptune.configs.impl.MenusLocale;
import dev.lrxh.neptune.utils.ItemBuilder;
import dev.lrxh.neptune.utils.menu.Button;
import dev.lrxh.neptune.utils.menu.PaginatedMenu;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class PageButton
extends Button {
    private final int mod;
    private final PaginatedMenu menu;

    public PageButton(int slot, int mod, PaginatedMenu menu) {
        super(slot);
        this.mod = mod;
        this.menu = menu;
    }

    @Override
    public ItemStack getItemStack(Player player) {
        List<String> lore;
        String name;
        Material material;
        boolean hasPage;
        boolean isNext = this.mod > 0;
        boolean bl = hasPage = isNext ? this.hasNext(player) : this.hasPrevious(player);
        if (isNext) {
            if (hasPage) {
                material = Material.valueOf((String)MenusLocale.PAGINATION_NEXT_PAGE_ENABLED_MATERIAL.getString());
                name = MenusLocale.PAGINATION_NEXT_PAGE_ENABLED_NAME.getString();
                lore = MenusLocale.PAGINATION_NEXT_PAGE_ENABLED_LORE.getStringList();
            } else {
                material = Material.valueOf((String)MenusLocale.PAGINATION_NEXT_PAGE_DISABLED_MATERIAL.getString());
                name = MenusLocale.PAGINATION_NEXT_PAGE_DISABLED_NAME.getString();
                lore = MenusLocale.PAGINATION_NEXT_PAGE_DISABLED_LORE.getStringList();
            }
        } else if (hasPage) {
            material = Material.valueOf((String)MenusLocale.PAGINATION_PREVIOUS_PAGE_ENABLED_MATERIAL.getString());
            name = MenusLocale.PAGINATION_PREVIOUS_PAGE_ENABLED_NAME.getString();
            lore = MenusLocale.PAGINATION_PREVIOUS_PAGE_ENABLED_LORE.getStringList();
        } else {
            material = Material.valueOf((String)MenusLocale.PAGINATION_PREVIOUS_PAGE_DISABLED_MATERIAL.getString());
            name = MenusLocale.PAGINATION_PREVIOUS_PAGE_DISABLED_NAME.getString();
            lore = MenusLocale.PAGINATION_PREVIOUS_PAGE_DISABLED_LORE.getStringList();
        }
        return new ItemBuilder(material).name(name).lore(lore, player).build();
    }

    @Override
    public void onClick(ClickType clickType, Player player) {
        if (this.mod > 0) {
            if (this.hasNext(player)) {
                this.menu.modPage(player, this.mod);
            }
        } else if (this.hasPrevious(player)) {
            this.menu.modPage(player, this.mod);
        }
    }

    private boolean hasNext(Player player) {
        int pg = this.menu.getPage() + this.mod;
        return this.menu.getPages(player) >= pg;
    }

    private boolean hasPrevious(Player player) {
        int pg = this.menu.getPage() + this.mod;
        return pg > 0;
    }
}

