/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.utils.menu;

import dev.lrxh.neptune.configs.impl.MenusLocale;
import dev.lrxh.neptune.utils.menu.Button;
import dev.lrxh.neptune.utils.menu.Filter;
import dev.lrxh.neptune.utils.menu.Menu;
import dev.lrxh.neptune.utils.menu.PageButton;
import dev.lrxh.neptune.utils.menu.impl.DisplayButton;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public abstract class PaginatedMenu
extends Menu {
    private int page = 1;

    public PaginatedMenu(String title, int size, Filter filter) {
        super(title, size, filter);
    }

    public final void modPage(Player player, int mod) {
        this.page += mod;
        this.getButtons(player).clear();
        this.open(player);
    }

    public final int getPages(Player player) {
        int buttonAmount = this.getAllPagesButtons(player).size();
        if (buttonAmount == 0) {
            return 1;
        }
        return (int)Math.ceil((double)buttonAmount / (double)this.getMaxItemsPerPage());
    }

    @Override
    public final List<Button> getButtons(Player player) {
        int minIndex = (int)((double)(this.page - 1) * (double)this.getMaxItemsPerPage());
        int maxIndex = (int)((double)this.page * (double)this.getMaxItemsPerPage());
        int topIndex = 0;
        ArrayList<Button> buttons = new ArrayList<Button>();
        for (Button button : this.getAllPagesButtons(player)) {
            int ind = button.getSlot();
            if (ind < minIndex || ind >= maxIndex) continue;
            button.setSlot(ind -= (int)((double)this.getMaxItemsPerPage() * (double)(this.page - 1)) - 9);
            buttons.add(button);
            if (ind <= topIndex) continue;
            topIndex = ind;
        }
        buttons.add(new DisplayButton(MenusLocale.PAGINATION_CURRENT_PAGE_SLOT.getInt(), Material.getMaterial((String)MenusLocale.PAGINATION_CURRENT_PAGE_MATERIAL.getString()), MenusLocale.PAGINATION_CURRENT_PAGE_NAME.getString().replaceAll("<currentPage>", String.valueOf(this.page)).replaceAll("<maxPage>", String.valueOf(this.getPages(player)))));
        buttons.add(new PageButton(5, 1, this));
        buttons.add(new PageButton(3, -1, this));
        List<Button> global = this.getGlobalButtons(player);
        if (global != null) {
            buttons.addAll(global);
        }
        return buttons;
    }

    public int getMaxItemsPerPage() {
        return 18;
    }

    public List<Button> getGlobalButtons(Player player) {
        return null;
    }

    public abstract List<Button> getAllPagesButtons(Player var1);

    @Generated
    public int getPage() {
        return this.page;
    }
}

