/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.utils.menu.impl;

import dev.lrxh.neptune.utils.ItemBuilder;
import dev.lrxh.neptune.utils.menu.Button;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class DisplayButton
extends Button {
    private final ItemStack itemStack;
    private final String name;
    private final Consumer<Player> action;

    public DisplayButton(int slot, Material itemStack, String name) {
        super(slot, false);
        this.itemStack = new ItemStack(itemStack);
        this.name = name;
        this.action = null;
    }

    public DisplayButton(int slot, Material itemStack, String name, Consumer<Player> action) {
        super(slot, false);
        this.itemStack = new ItemStack(itemStack);
        this.name = name;
        this.action = action;
    }

    public DisplayButton(int slot, ItemStack itemStack, String name) {
        super(slot, false);
        this.itemStack = new ItemStack(itemStack);
        this.name = name;
        this.action = null;
    }

    public DisplayButton(int slot, ItemStack itemStack) {
        super(slot, false);
        this.itemStack = new ItemStack(itemStack);
        this.name = null;
        this.action = null;
    }

    @Override
    public ItemStack getItemStack(Player player) {
        if (this.name != null) {
            return new ItemBuilder(this.itemStack).name(this.name).build();
        }
        return new ItemBuilder(this.itemStack).build();
    }

    @Override
    public void onClick(ClickType type, Player player) {
        if (this.action == null) {
            return;
        }
        this.action.accept(player);
    }
}

