/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.utils.tasks;

import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.utils.tasks.NeptuneRunnable;
import dev.lrxh.neptune.utils.tasks.TaskListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TaskScheduler {
    private static TaskScheduler instance;
    private final List<NeptuneRunnable> tasks = new CopyOnWriteArrayList<NeptuneRunnable>();
    private final TaskListener listener = new TaskListener();

    public TaskScheduler() {
        Neptune.get().getServer().getPluginManager().registerEvents((Listener)this.listener, (Plugin)Neptune.get());
    }

    public static TaskScheduler get() {
        if (instance == null) {
            instance = new TaskScheduler();
        }
        return instance;
    }

    public void startTask(NeptuneRunnable task, long delay, long period) {
        this.tasks.add(task);
        task.runTaskTimer((Plugin)Neptune.get(), delay, period);
    }

    public void startTask(NeptuneRunnable task) {
        this.tasks.add(task);
        task.runTask((Plugin)Neptune.get());
    }

    public void startTaskCurrentTick(NeptuneRunnable task) {
        this.listener.getRunnables().add(task);
    }

    public void startTaskLater(NeptuneRunnable task, long delay) {
        this.tasks.add(task);
        task.runTaskLater((Plugin)Neptune.get(), delay);
    }

    public void stopAllTasks() {
        for (NeptuneRunnable task : this.tasks) {
            task.stop();
        }
    }

    public void removeTask(NeptuneRunnable task) {
        this.tasks.remove((Object)task);
    }
}

