/*
 * Decompiled with CFR 0.152.
 */
package fr.mrmicky.fastboard;

import dev.lrxh.neptune.utils.CC;
import fr.mrmicky.fastboard.FastManager;
import fr.mrmicky.fastboard.adventure.FastBoard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class FastRunnable
implements Runnable {
    private FastManager manager;

    @Override
    public void run() {
        Iterator<Map.Entry<UUID, FastBoard>> iterator = this.manager.boards.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, FastBoard> entry = iterator.next();
            Player player = Bukkit.getPlayer((UUID)entry.getKey());
            if (player == null || !player.isOnline()) {
                iterator.remove();
                continue;
            }
            FastBoard board = entry.getValue();
            String rawTitle = this.getSafeTitle(player);
            List<String> rawLines = this.getSafeLines(player);
            board.updateTitle(CC.color(rawTitle));
            ArrayList<TextComponent> newLines = new ArrayList<TextComponent>();
            for (String line : rawLines) {
                newLines.add(CC.color(line));
            }
            board.updateLines(newLines);
        }
    }

    private String getSafeTitle(Player player) {
        try {
            return this.manager.fastAdapter.getTitle(player);
        }
        catch (Exception e) {
            return "Default Title";
        }
    }

    private List<String> getSafeLines(Player player) {
        try {
            return this.manager.fastAdapter.getLines(player);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    @Generated
    public FastRunnable(FastManager manager) {
        this.manager = manager;
    }
}

