/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.color;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.color.MapColorHelper;
import net.mehvahdjukaar.polytone.mixins.accessor.DustParticleOptionAccessor;
import net.mehvahdjukaar.polytone.mixins.accessor.SheepAccessor;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.SingleJsonOrPropertiesReloadListener;
import net.mehvahdjukaar.polytone.utils.Vec3f;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1826;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2457;
import net.minecraft.class_2789;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3620;
import net.minecraft.class_5251;
import net.minecraft.class_5253;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ColorManager
extends SingleJsonOrPropertiesReloadListener {
    private final Object2IntMap<class_3620> vanillaMapColors = new Object2IntOpenHashMap();
    private final Map<class_1767, Integer> vanillaFireworkColors = new EnumMap<class_1767, Integer>(class_1767.class);
    private final Map<class_1767, Integer> vanillaDiffuseColors = new EnumMap<class_1767, Integer>(class_1767.class);
    private final Map<class_1767, Integer> vanillaTextColors = new EnumMap<class_1767, Integer>(class_1767.class);
    private final Map<class_124, Integer> vanillaChatFormatting = new EnumMap<class_124, Integer>(class_124.class);
    private final Object2IntMap<class_1826> vanillaEggsBackgrounds = new Object2IntOpenHashMap();
    private final Object2IntMap<class_1826> vanillaEggsHighlight = new Object2IntOpenHashMap();
    private final Object2IntMap<class_1291> vanillaEffectColors = new Object2IntOpenHashMap();
    private final Map<class_1291, Function<class_1293, class_2394>> vanillaEffectParticles = new HashMap<class_1291, Function<class_1293, class_2394>>();
    private final EnumMap<class_2789, Integer> vanillaBorderStatus = new EnumMap(class_2789.class);
    private final Map<class_1767, Integer> customSheepColors = new EnumMap<class_1767, Integer>(class_1767.class);
    protected final List<class_243> originalRedstoneWireColors = Arrays.stream(class_2457.field_24466).toList();
    @Nullable
    class_2960 xpOrbParticle;
    @Nullable
    private BlockContextExpression xpOrbColor;
    @Nullable
    private BlockContextExpression xpOrbColorR;
    @Nullable
    private BlockContextExpression xpOrbColorG;
    @Nullable
    private BlockContextExpression xpOrbColorB;
    private Integer xpBar = null;
    private Integer splash = null;
    private Integer enchantTableXp = null;
    @Nullable
    private Integer fishingLineColor = null;
    @Nullable
    private Vec3f fishingLineOffset = null;

    public ColorManager() {
        super("colo_manager", "color.properties", "colors.json", new String[]{"polytone", "colormatic", "vanadium", "optifine"});
    }

    public Integer getXpBar() {
        return this.xpBar;
    }

    public Integer getSplash() {
        return this.splash;
    }

    @Override
    protected void parseWithLevel(Map<class_2960, JsonElement> jsons, class_6903<JsonElement> ops, class_5455 access) {
        ArrayList<class_2960> keySet = new ArrayList<class_2960>(jsons.keySet());
        Lists.reverse(keySet);
        for (class_2960 k : keySet) {
            JsonElement root = jsons.get(k);
            try {
                this.parseColorJson(root, k);
            }
            catch (Exception e1) {
                Polytone.LOGGER.error("Failed to parse color JSON in file {}", (Object)k, (Object)e1);
            }
        }
        this.regenSheepColors();
    }

    private void parseColorJson(JsonElement root, class_2960 fileId) {
        JsonObject obj = root.getAsJsonObject();
        ColorManager.doWith(obj, "map", (k, v) -> {
            class_3620 color = MapColorHelper.byName(k);
            if (color != null) {
                int col = ColorManager.parseHex(v);
                if (!this.vanillaMapColors.containsKey((Object)color)) {
                    this.vanillaMapColors.put((Object)color, color.field_16011);
                }
                color.field_16011 = col;
            } else {
                Polytone.LOGGER.warn("Unknown MapColor with name {}", k);
            }
        });
        ColorManager.doWith(obj, "dye", (k, v) -> {
            class_1767 color = class_1767.method_7793((String)k, null);
            if (color == null) {
                Polytone.LOGGER.warn("Unknown DyeColor with name {}", k);
                return;
            }
            for (Map.Entry<String, JsonElement> entry : ColorManager.entries(v)) {
                String param = entry.getKey();
                int col = ColorManager.parseHex(entry.getValue());
                switch (param) {
                    case "diffuse": {
                        if (!this.vanillaDiffuseColors.containsKey(color)) {
                            this.vanillaDiffuseColors.put(color, color.method_7787());
                        }
                        color.field_7943 = class_5253.class_5254.method_57174((int)col);
                        break;
                    }
                    case "firework": {
                        if (!this.vanillaFireworkColors.containsKey(color)) {
                            this.vanillaFireworkColors.put(color, color.field_7960);
                        }
                        color.field_7960 = col;
                        break;
                    }
                    case "text": {
                        if (!this.vanillaTextColors.containsKey(color)) {
                            this.vanillaTextColors.put(color, color.field_16537);
                        }
                        color.field_16537 = col;
                    }
                }
            }
        });
        ColorManager.doWith(obj, "particle", (k, v) -> {
            class_2960 id = class_2960.method_60654((String)k.replace("\\", ""));
            try {
                int hex = ColorManager.parseHex(v);
                Polytone.PARTICLE_MODIFIERS.addCustomParticleColor(id, String.valueOf(hex));
            }
            catch (Exception e) {
                Polytone.PARTICLE_MODIFIERS.addCustomParticleColor(id, v.getAsString());
            }
        });
        ColorManager.doWith(obj, "fishing_line", (k, v) -> {
            switch (k) {
                case "color": {
                    this.fishingLineColor = ColorManager.parseHex(v);
                    break;
                }
                case "offset": {
                    this.fishingLineOffset = (Vec3f)((Pair)Vec3f.CODEC.decode((DynamicOps)JsonOps.INSTANCE, v).getOrThrow()).getFirst();
                }
            }
        });
        ColorManager.doWith(obj, "world_border", (k, v) -> {
            class_2789 status = class_2789.valueOf((String)k.toLowerCase(Locale.ROOT));
            int col = ColorManager.parseHex(v);
            if (!this.vanillaBorderStatus.containsKey(status)) {
                this.vanillaBorderStatus.put(status, status.method_11999());
            }
            status.field_12755 = col;
        });
        ColorManager.doWith(obj, "effect", (k, v) -> {
            class_2960 id = class_2960.method_60654((String)k.replace("\\", ""));
            class_2394 particle = (class_2394)ColorManager.get(v, "particle", class_2398.field_25125);
            String color = ColorManager.getString(v, "color");
            Integer col = color == null && v instanceof JsonPrimitive ? Integer.valueOf(ColorManager.parseHex(v)) : Integer.valueOf(ColorManager.parseHex(color));
            if (!id.method_12832().equals("empty")) {
                if (id.method_12832().equals("water")) {
                    class_1844.field_49277 = col;
                } else {
                    class_1291 effect = class_7923.field_41174.method_17966(id).orElse(null);
                    if (effect != null) {
                        if (!this.vanillaEffectColors.containsKey((Object)effect)) {
                            this.vanillaEffectColors.put((Object)effect, effect.method_5556());
                        }
                        effect.field_5886 = col;
                        if (particle != null) {
                            if (!this.vanillaEffectParticles.containsKey(effect)) {
                                this.vanillaEffectParticles.put(effect, effect.field_49790);
                            }
                            effect.field_49790 = mobEffectInstance -> particle;
                        }
                    } else {
                        Polytone.LOGGER.warn("Unknown Mob Effect with name {}", (Object)id);
                    }
                }
            }
        });
        ColorManager.doWith(obj, "egg", (k, v) -> {
            class_1299 entity;
            class_2960 id = class_2960.method_60654((String)k.replace("\\", ""));
            class_1792 item = class_7923.field_41178.method_17966(id).orElse(null);
            if (item == null && (entity = (class_1299)class_7923.field_41177.method_17966(id).orElse(null)) != null) {
                item = class_1826.method_8019((class_1299)entity);
            }
            if (item == null) {
                item = class_7923.field_41178.method_17966(id.method_48331("_spawn_egg")).orElse(null);
            }
            if (item instanceof class_1826) {
                String spots;
                class_1826 spawnEggItem = (class_1826)item;
                String shell = ColorManager.getString(v, "shell");
                if (shell != null) {
                    if (!this.vanillaEggsBackgrounds.containsKey((Object)spawnEggItem)) {
                        this.vanillaEggsBackgrounds.put((Object)spawnEggItem, spawnEggItem.field_8916);
                    }
                    spawnEggItem.field_8916 = ColorManager.parseHex(shell);
                }
                if ((spots = ColorManager.getString(v, "spots")) != null) {
                    if (!this.vanillaEggsHighlight.containsKey((Object)spawnEggItem)) {
                        this.vanillaEggsHighlight.put((Object)spawnEggItem, spawnEggItem.field_8915);
                    }
                    spawnEggItem.field_8915 = ColorManager.parseHex(spots);
                }
            } else {
                Polytone.LOGGER.warn("Unknown or invalid Spawn Egg Item with name {}", (Object)id);
            }
        });
        ColorManager.doWith(obj, "sheep", (k, v) -> {
            class_1767 color = class_1767.method_7793((String)k, null);
            if (color != null) {
                int col = class_5253.class_5254.method_57174((int)ColorManager.parseHex(v));
                this.customSheepColors.put(color, col);
            } else {
                Polytone.LOGGER.warn("Unknown Dye Color with name {}", k);
            }
        });
        ColorManager.doWith(obj, "xporb", (k, v) -> {
            switch (k) {
                case "particle_replacement": {
                    Polytone.PARTICLE_MODIFIERS.setXpOrbReplace((JsonElement)v);
                    break;
                }
                case "color": {
                    this.xpOrbColor = new BlockContextExpression(v.getAsString());
                    break;
                }
                case "red": {
                    this.xpOrbColorR = new BlockContextExpression(v.getAsString());
                    break;
                }
                case "green": {
                    this.xpOrbColorG = new BlockContextExpression(v.getAsString());
                    break;
                }
                case "blue": {
                    this.xpOrbColorB = new BlockContextExpression(v.getAsString());
                }
            }
        });
        ColorManager.doWith(obj, "redstone", (k, v) -> {
            int code = Integer.parseInt(k);
            if (code < class_2457.field_24466.length) {
                int col = ColorManager.parseHex(v);
                float[] rgb = ColorUtils.unpack(col);
                class_2457.field_24466[code] = new class_243((double)rgb[0], (double)rgb[1], (double)rgb[2]);
                if (code == 15) {
                    Vector3f maxPower;
                    class_2390.field_28272 = maxPower = new Vector3f(rgb[0], rgb[1], rgb[2]);
                    ((DustParticleOptionAccessor)class_2390.field_11188).setColor(maxPower);
                }
            } else {
                Polytone.LOGGER.warn("Redstone color index must be between 0 and 15");
            }
        });
        ColorManager.doWith(obj, "text", (k, v) -> {
            if (k.equals("splash")) {
                this.splash = ColorManager.parseHex(v);
            } else if (k.equals("xpbar")) {
                this.xpBar = ColorManager.parseHex(v);
            } else if (k.startsWith("code:")) {
                String s = k.substring(5);
                int code = Integer.parseInt(s);
                class_124 text = class_124.method_534((int)code);
                this.setTextColor(text, ColorManager.parseHex(v));
            } else if (k.equals("code")) {
                for (Map.Entry<String, JsonElement> entry : ColorManager.entries(v)) {
                    String s = entry.getKey();
                    int code = Integer.parseInt(s);
                    class_124 text = class_124.method_534((int)code);
                    this.setTextColor(text, ColorManager.parseHex(entry.getValue()));
                }
            } else {
                class_124 text = class_124.method_533((String)k);
                this.setTextColor(text, ColorManager.parseHex(v));
            }
        });
        ColorManager.doWith(obj, "palette", (k, v) -> {
            if (k.equals("block") && v.isJsonObject()) {
                for (Map.Entry<String, JsonElement> entry : ColorManager.getEntries(v.getAsJsonObject(), "block")) {
                    String path = entry.getKey().replace("~/colormap/", fileId.method_12836() + ":");
                    Polytone.BLOCK_MODIFIERS.addSimpleColormap(class_2960.method_60654((String)path), entry.getValue().getAsString());
                }
            }
        });
    }

    private void setTextColor(class_124 text, int col) {
        if (!this.vanillaChatFormatting.containsKey(text)) {
            this.vanillaChatFormatting.put(text, text.method_532());
        }
        text.field_1053 = col;
        class_5251 tc = class_5251.method_27718((class_124)text);
        tc.field_24364 = col;
    }

    private static void doWith(JsonObject obj, String key, BiConsumer<String, JsonElement> entryHandler) {
        try {
            if (obj.has(key)) {
                JsonObject sub = class_3518.method_15296((JsonObject)obj, (String)key);
                for (Map.Entry entry : sub.entrySet()) {
                    entryHandler.accept((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }
        catch (JsonParseException e) {
            throw new JsonParseException("Failed to parse color JSON for key: " + key, (Throwable)e);
        }
    }

    private static Set<Map.Entry<String, JsonElement>> getEntries(JsonObject element, String key) {
        JsonElement elements = element.get(key);
        if (elements != null && elements.isJsonObject()) {
            return elements.getAsJsonObject().entrySet();
        }
        return Collections.emptySet();
    }

    private static <T> T get(JsonElement element, String key, Codec<T> codec) {
        JsonObject jo;
        JsonElement joo;
        if (element instanceof JsonObject && (joo = (jo = (JsonObject)element).get(key)) != null) {
            return (T)((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)joo).getOrThrow()).getFirst();
        }
        return null;
    }

    @Nullable
    private static String getString(JsonElement element, String key) {
        JsonObject jo;
        JsonElement joo;
        if (element instanceof JsonObject && (joo = (jo = (JsonObject)element).get(key)) != null && joo.isJsonPrimitive() && joo.getAsJsonPrimitive().isString()) {
            return joo.getAsString();
        }
        return null;
    }

    private static Set<Map.Entry<String, JsonElement>> entries(JsonElement element) {
        if (element.isJsonObject()) {
            return element.getAsJsonObject().entrySet();
        }
        return Collections.emptySet();
    }

    private static int parseHex(JsonElement obj) {
        return (Integer)((Pair)ColorUtils.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).getOrThrow()).getFirst();
    }

    private static int parseHex(String str) {
        str = str.replace("#", "").replace("0x", "");
        return Integer.parseInt(str.trim(), 16);
    }

    @Override
    protected void applyWithLevel(class_5455 access, boolean isLogIn) {
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        class_1826 item;
        class_1291 effect;
        class_3620 color;
        class_1844.field_49277 = 3694022;
        this.xpBar = null;
        this.xpOrbParticle = null;
        this.xpOrbColor = null;
        this.xpOrbColorR = null;
        this.xpOrbColorG = null;
        this.xpOrbColorB = null;
        this.fishingLineOffset = null;
        this.fishingLineColor = null;
        for (Map.Entry entry : this.vanillaMapColors.entrySet()) {
            color = (class_3620)entry.getKey();
            color.field_16011 = (Integer)entry.getValue();
        }
        this.vanillaMapColors.clear();
        for (Map.Entry entry : this.vanillaDiffuseColors.entrySet()) {
            color = (class_1767)entry.getKey();
            color.field_7943 = (Integer)entry.getValue();
        }
        this.vanillaDiffuseColors.clear();
        for (Map.Entry entry : this.vanillaFireworkColors.entrySet()) {
            color = (class_1767)entry.getKey();
            color.field_7960 = (Integer)entry.getValue();
        }
        this.vanillaFireworkColors.clear();
        for (Map.Entry entry : this.vanillaTextColors.entrySet()) {
            color = (class_1767)entry.getKey();
            color.field_16537 = (Integer)entry.getValue();
        }
        this.vanillaTextColors.clear();
        for (Map.Entry entry : this.vanillaChatFormatting.entrySet()) {
            class_124 text = (class_124)entry.getKey();
            text.field_1053 = (Integer)entry.getValue();
            class_5251 tc = class_5251.method_27718((class_124)text);
            tc.field_24364 = (Integer)entry.getValue();
        }
        this.vanillaChatFormatting.clear();
        for (Object2IntMap.Entry entry : this.vanillaEffectColors.object2IntEntrySet()) {
            effect = (class_1291)entry.getKey();
            effect.field_5886 = entry.getIntValue();
        }
        this.vanillaEffectColors.clear();
        for (Map.Entry entry : this.vanillaEffectParticles.entrySet()) {
            effect = (class_1291)entry.getKey();
            effect.field_49790 = (Function)entry.getValue();
        }
        this.vanillaEffectParticles.clear();
        for (Map.Entry entry : this.vanillaBorderStatus.entrySet()) {
            class_2789 status = (class_2789)entry.getKey();
            status.field_12755 = (Integer)entry.getValue();
        }
        this.vanillaBorderStatus.clear();
        for (Map.Entry entry : this.vanillaEggsBackgrounds.entrySet()) {
            item = (class_1826)entry.getKey();
            item.field_8916 = (Integer)entry.getValue();
        }
        this.vanillaEggsBackgrounds.clear();
        for (Map.Entry entry : this.vanillaEggsHighlight.entrySet()) {
            item = (class_1826)entry.getKey();
            item.field_8915 = (Integer)entry.getValue();
        }
        this.vanillaEggsHighlight.clear();
        class_2457.field_24466 = this.originalRedstoneWireColors.toArray(new class_243[0]);
        class_2390.field_28272 = new Vector3f(1.0f, 0.0f, 0.0f);
        ((DustParticleOptionAccessor)class_2390.field_11188).setColor(class_2390.field_28272);
    }

    public void regenSheepColors() {
        class_1472.field_6867 = new EnumMap(class_1767.class);
        for (class_1767 d : class_1767.values()) {
            class_1472.field_6867.put(d, SheepAccessor.invokeCreateSheepColor(d));
        }
        class_1472.field_6867.putAll(this.customSheepColors);
        this.customSheepColors.clear();
    }

    public float @Nullable [] getXpOrbColor(class_1303 orb, float partialTicks) {
        class_1937 level = orb.method_37908();
        float time = (float)orb.field_6012 + partialTicks;
        class_243 position = orb.method_19538();
        if (this.xpOrbColor != null) {
            int color = (int)this.xpOrbColor.getValue(position, time, level);
            return ColorUtils.unpack(color);
        }
        if (this.xpOrbColorR == null && this.xpOrbColorG == null && this.xpOrbColorB == null) {
            return null;
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (this.xpOrbColorR != null) {
            r = (float)this.xpOrbColorR.getValue(position, time, level);
        }
        if (this.xpOrbColorG != null) {
            g = (float)this.xpOrbColorG.getValue(position, time, level);
        }
        if (this.xpOrbColorB != null) {
            b = (float)this.xpOrbColorB.getValue(position, time, level);
        }
        return new float[]{r, g, b};
    }

    @Nullable
    public Vec3f getFishingLineOffset() {
        return this.fishingLineOffset;
    }

    @Nullable
    public Integer getFishingLineColor() {
        return this.fishingLineColor;
    }
}

