/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.colormap.IndexCompoundColorGetter;
import net.mehvahdjukaar.polytone.item.ItemModelOverride;
import net.mehvahdjukaar.polytone.tabs.CreativeTabModifier;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.mehvahdjukaar.polytone.utils.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_325;
import net.minecraft.class_326;
import net.minecraft.class_5699;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public record ItemModifier(Optional<? extends class_326> tintGetter, Optional<IColorGetter> barColor, Optional<class_1814> rarity, List<class_2561> tooltips, List<Pattern> removedTooltips, List<ItemModelOverride> customModels, Targets targets) {
    public static final Codec<ItemModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IndexCompoundColorGetter.SINGLE_OR_MULTIPLE.optionalFieldOf("colormap").forGetter(b -> b.tintGetter), (App)Colormap.CODEC.optionalFieldOf("bar_color").forGetter(ItemModifier::barColor), (App)class_1814.field_50001.optionalFieldOf("rarity").forGetter(ItemModifier::rarity), (App)CreativeTabModifier.COMPONENT_CODEC.listOf().optionalFieldOf("tooltips", List.of()).forGetter(ItemModifier::tooltips), (App)class_5699.field_37408.listOf().optionalFieldOf("removed_tooltips", List.of()).forGetter(ItemModifier::removedTooltips), (App)ItemModelOverride.CODEC.listOf().optionalFieldOf("custom_models", List.of()).forGetter(ItemModifier::customModels), (App)Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).forGetter(ItemModifier::targets)).apply((Applicative)instance, ItemModifier::new));
    public static final Codec<Partial> CODEC_ONLY_MODELS = RecordCodecBuilder.create(instance -> instance.group((App)ItemModelOverride.CODEC_MODEL_ONLY.listOf().optionalFieldOf("custom_models", List.of()).forGetter(Partial::customModels)).apply((Applicative)instance, Partial::new));

    public static ItemModifier ofItemColor(Colormap colormap) {
        return new ItemModifier(Optional.of(colormap), Optional.empty(), Optional.empty(), List.of(), List.of(), List.of(), Targets.EMPTY);
    }

    public static ItemModifier ofBarColor(Colormap colormap) {
        return new ItemModifier(Optional.empty(), Optional.of(colormap), Optional.empty(), List.of(), List.of(), List.of(), Targets.EMPTY);
    }

    public ItemModifier merge(ItemModifier newMod) {
        return new ItemModifier(newMod.tintGetter.isPresent() ? newMod.tintGetter : this.tintGetter, newMod.barColor.isPresent() ? newMod.barColor : this.barColor, newMod.rarity.isPresent() ? newMod.rarity : this.rarity, Utils.mergeList(newMod.tooltips, this.tooltips), Utils.mergeList(newMod.removedTooltips, this.removedTooltips), Utils.mergeList(newMod.customModels, this.customModels), newMod.targets.merge(this.targets));
    }

    public ItemModifier apply(class_1792 item) {
        class_1814 oldRarity = null;
        if (this.rarity.isPresent()) {
            class_9323 components = item.method_57347();
            oldRarity = (class_1814)components.method_57829(class_9334.field_50073);
            class_9323.class_9324 builder = class_9323.method_57827();
            builder.method_57839(components);
            builder.method_57840(class_9334.field_50073, (Object)this.rarity.get());
            item.field_49263 = (class_9323)class_1792.class_1793.field_49264.intern((Object)builder.method_57838());
        }
        class_326 oldColor = null;
        if (this.tintGetter.isPresent()) {
            class_325 itemColors = class_310.method_1551().field_1760;
            oldColor = PlatStuff.getItemColor(itemColors, item);
            itemColors.method_1708(this.tintGetter.get(), new class_1935[]{item});
        }
        return new ItemModifier(Optional.ofNullable(oldColor), Optional.empty(), Optional.ofNullable(oldRarity), List.of(), List.of(), List.of(), Targets.EMPTY);
    }

    @Nullable
    public Integer getBarColor(class_1799 itemStack) {
        return this.barColor.map(c -> c.getColor(itemStack, 0)).orElse(null);
    }

    public boolean hasTint() {
        return this.tintGetter.isPresent();
    }

    public class_326 getTint() {
        return this.tintGetter.orElse(null);
    }

    public class_326 getBarColor() {
        return this.barColor.orElse(null);
    }

    public boolean hasBarColor() {
        return this.barColor.isPresent();
    }

    public void modifyTooltips(List<class_2561> tooltips) {
        tooltips.removeIf(t -> this.removedTooltips.stream().anyMatch(p -> p.matcher(t.getString()).matches()));
        for (class_2561 t2 : this.tooltips) {
            tooltips.add(0, t2);
        }
    }

    public boolean shouldAttachToItem() {
        return !this.tooltips.isEmpty() || !this.removedTooltips.isEmpty() || this.barColor.isPresent();
    }

    public record Partial(List<ItemModelOverride.Partial> customModels) {
    }
}

