/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_746;

public class CompoundReloader
implements class_3302 {
    private final List<PartialReloader<?>> children;
    private final List<?> childrenResourcesCache = new ArrayList();

    public CompoundReloader(PartialReloader<?> ... reloaders) {
        this.children = List.of(reloaders);
    }

    public final CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        List<CompletableFuture> futures = this.children.stream().map(child -> CompletableFuture.supplyAsync(() -> child.prepare(resourceManager), backgroundExecutor)).collect(Collectors.toList());
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()))).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0))).thenAcceptAsync(preparedList -> {
            this.childrenResourcesCache.clear();
            this.childrenResourcesCache.addAll((Collection<?>)preparedList);
            class_638 level = class_310.method_1551().field_1687;
            if (level != null) {
                try {
                    this.applyWithLevel(level.method_30349(), false);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, gameExecutor);
    }

    public void applyWithLevel(class_5455 registryAccess, boolean firstLogin) {
        class_638 level;
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.resetWithLevel(false);
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        for (int i = 0; i < this.childrenResourcesCache.size(); ++i) {
            PartialReloader<?> c = this.children.get(i);
            try {
                this.processTyped(c, this.childrenResourcesCache.get(i), (class_6903<JsonElement>)ops, registryAccess);
                continue;
            }
            catch (Exception e) {
                String message = String.valueOf(c) + " failed to parse some resources";
                Polytone.logException(e, message);
                Polytone.iMessedUp = true;
                Polytone.LOGGER.error(message);
                throw e;
            }
        }
        for (PartialReloader<?> c : this.children) {
            try {
                c.applyWithLevel(registryAccess, firstLogin);
            }
            catch (Exception e) {
                String message = String.valueOf(c) + " failed to apply some resources";
                Polytone.logException(e, message);
                Polytone.iMessedUp = true;
                Polytone.LOGGER.error(message);
                throw e;
            }
        }
        Polytone.LOGGER.info("Reloaded Polytone Resources in {} ms", (Object)stopwatch.elapsed().toMillis());
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            class_1703 container = player.field_7512;
            class_1723 inv = player.field_7498;
            if (inv.getClass() == class_1723.class) {
                player.field_7498 = new class_1723(player.method_31548(), inv.field_7827, (class_1657)player);
                if (container == inv) {
                    player.field_7512 = player.field_7498;
                }
            }
        }
        if ((level = class_310.method_1551().field_1687) instanceof class_638) {
            class_638 cl = level;
            cl.method_23784();
        }
    }

    private <T> void processTyped(PartialReloader<T> reloader, Object object, class_6903<JsonElement> ops, class_5455 access) {
        reloader.parseWithLevel(object, ops, access);
    }

    public void resetWithLevel(boolean isLogOff) {
        for (PartialReloader<?> c : this.children) {
            c.resetWithLevel(isLogOff);
        }
    }

    public void earlyProcess(class_3300 resourceManager) {
        for (PartialReloader<?> c : this.children) {
            c.earlyProcess(resourceManager);
        }
        PlatStuff.doAddModels();
    }
}

