/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.lightmap.Lightmap;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_5294;
import org.jetbrains.annotations.Nullable;

public record DimensionEffectsModifier(Optional<Either<Float, BlockContextExpression>> cloudLevel, Optional<Boolean> hasGround, Optional<class_5294.class_5401> skyType, Optional<Boolean> forceBrightLightmap, Optional<Boolean> constantAmbientLight, Optional<IColorGetter> fogColor, Optional<IColorGetter> terrainFogColor, Optional<IColorGetter> skyColor, Optional<IColorGetter> sunsetColor, boolean noWeatherFogDarken, boolean noWeatherSkyDarken, Optional<Lightmap> lightmap, Targets targets) {
    public static final Codec<class_5294.class_5401> SKY_TYPE_CODEC = Codec.STRING.xmap(class_5294.class_5401::valueOf, Enum::name);
    public static final Decoder<DimensionEffectsModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)Codec.FLOAT, BlockContextExpression.CODEC).optionalFieldOf("cloud_level").forGetter(DimensionEffectsModifier::cloudLevel), (App)Codec.BOOL.optionalFieldOf("has_ground").forGetter(DimensionEffectsModifier::hasGround), (App)SKY_TYPE_CODEC.optionalFieldOf("sky_type").forGetter(DimensionEffectsModifier::skyType), (App)Codec.BOOL.optionalFieldOf("force_bright_lightmap").forGetter(DimensionEffectsModifier::forceBrightLightmap), (App)Codec.BOOL.optionalFieldOf("constant_ambient_light").forGetter(DimensionEffectsModifier::constantAmbientLight), (App)Colormap.CODEC.optionalFieldOf("fog_colormap").forGetter(DimensionEffectsModifier::fogColor), (App)Colormap.CODEC.optionalFieldOf("terrain_fog_colormap").forGetter(DimensionEffectsModifier::terrainFogColor), (App)Colormap.CODEC.optionalFieldOf("sky_colormap").forGetter(DimensionEffectsModifier::skyColor), (App)Colormap.CODEC.optionalFieldOf("sunset_colormap").forGetter(DimensionEffectsModifier::sunsetColor), (App)Codec.BOOL.optionalFieldOf("no_weather_fog_darken", (Object)false).forGetter(DimensionEffectsModifier::noWeatherFogDarken), (App)Codec.BOOL.optionalFieldOf("no_weather_sky_darken", (Object)false).forGetter(DimensionEffectsModifier::noWeatherSkyDarken), (App)Polytone.LIGHTMAPS.byNameCodec().optionalFieldOf("lightmap").forGetter(DimensionEffectsModifier::lightmap), (App)Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).forGetter(DimensionEffectsModifier::targets)).apply((Applicative)instance, DimensionEffectsModifier::new));

    public static DimensionEffectsModifier ofFogColor(Colormap colormap) {
        return new DimensionEffectsModifier(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(colormap), Optional.empty(), Optional.empty(), Optional.empty(), false, false, Optional.empty(), Targets.EMPTY);
    }

    public static DimensionEffectsModifier ofSkyColor(Colormap colormap) {
        return new DimensionEffectsModifier(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(colormap), Optional.empty(), false, false, Optional.empty(), Targets.EMPTY);
    }

    public static DimensionEffectsModifier ofSunsetColor(Colormap colormap) {
        return new DimensionEffectsModifier(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(colormap), false, false, Optional.empty(), Targets.EMPTY);
    }

    public DimensionEffectsModifier merge(DimensionEffectsModifier newMod) {
        return new DimensionEffectsModifier(newMod.cloudLevel.isPresent() ? newMod.cloudLevel : this.cloudLevel, newMod.hasGround.isPresent() ? newMod.hasGround : this.hasGround, newMod.skyType.isPresent() ? newMod.skyType : this.skyType, newMod.forceBrightLightmap.isPresent() ? newMod.forceBrightLightmap : this.forceBrightLightmap, newMod.constantAmbientLight.isPresent() ? newMod.constantAmbientLight : this.constantAmbientLight, newMod.fogColor.isPresent() ? newMod.fogColor : this.fogColor, newMod.terrainFogColor.isPresent() ? newMod.terrainFogColor : this.terrainFogColor, newMod.skyColor.isPresent() ? newMod.skyColor : this.skyColor, newMod.sunsetColor.isPresent() ? newMod.sunsetColor : this.sunsetColor, newMod.noWeatherFogDarken | this.noWeatherFogDarken, newMod.noWeatherSkyDarken | this.noWeatherSkyDarken, newMod.lightmap.isPresent() ? newMod.lightmap : this.lightmap, newMod.targets.merge(this.targets));
    }

    @Nullable
    public class_322 getFogColormap() {
        return this.fogColor.orElse(null);
    }

    @Nullable
    public class_322 getTerrainFogColormap() {
        return this.terrainFogColor.orElse(null);
    }

    @Nullable
    public class_322 getSkyColormap() {
        return this.skyColor.orElse(null);
    }

    @Nullable
    public class_322 getSunsetColormap() {
        return this.sunsetColor.orElse(null);
    }

    public DimensionEffectsModifier applyInplace(class_2960 dimensionId) {
        class_5294 effects = PlatStuff.getDimensionEffects(dimensionId);
        Optional<Either<Float, BlockContextExpression>> oldCloud = Optional.empty();
        if (this.cloudLevel.isPresent() && this.cloudLevel.get().left().isPresent()) {
            oldCloud = Optional.of(Either.left((Object)Float.valueOf(effects.field_24611)));
            effects.field_24611 = ((Float)this.cloudLevel.get().left().get()).floatValue();
        }
        Optional<Boolean> oldGround = Optional.empty();
        if (this.hasGround.isPresent()) {
            oldGround = Optional.of(effects.field_24612);
            effects.field_24612 = this.hasGround.get();
        }
        Optional<class_5294.class_5401> oldSky = Optional.empty();
        if (this.skyType.isPresent()) {
            oldSky = Optional.of(effects.field_25637);
            effects.field_25637 = this.skyType.get();
        }
        Optional<Boolean> oldBright = Optional.empty();
        if (this.forceBrightLightmap.isPresent()) {
            oldBright = Optional.of(effects.field_24613);
            effects.field_24613 = this.forceBrightLightmap.get();
        }
        Optional<Boolean> oldAmbient = Optional.empty();
        if (this.constantAmbientLight.isPresent()) {
            oldAmbient = Optional.of(effects.field_25638);
            effects.field_25638 = this.constantAmbientLight.get();
        }
        return new DimensionEffectsModifier(oldCloud, oldGround, oldSky, oldBright, oldAmbient, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), false, false, Optional.empty(), Targets.EMPTY);
    }
}

