/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.mehvahdjukaar.polytone.colormap.ColormapExpressionProvider;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ModelResHelper;
import net.minecraft.class_1091;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public class ItemModelOverride {
    @Nullable
    protected final Dynamic<?> lazyComponent;
    @Nullable
    protected final Integer stackCount;
    @Nullable
    protected final Pattern pattern;
    @Nullable
    protected final class_2487 entityTag;
    @Nullable
    protected final ColormapExpressionProvider expression;
    protected class_1091 model;
    protected class_9323 decodedComponents;
    protected Map<class_9331<?>, class_2487> nbtMatchers;
    protected static final Codec<Map<class_2960, Float>> ITEM_PREDICATE_CODEC = Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)Codec.FLOAT);
    protected static final UnboundedMapCodec<class_9331<?>, class_2487> NBT_COMPONENTS_CODEC = Codec.unboundedMap((Codec)class_9331.field_49600, (Codec)class_2487.field_25128);
    public static final Codec<ItemModelOverride> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.PASSTHROUGH.optionalFieldOf("components").forGetter(o -> Optional.ofNullable(o.lazyComponent)), (App)ModelResHelper.MODEL_RES_CODEC.fieldOf("model").forGetter(ItemModelOverride::model), (App)Codec.INT.optionalFieldOf("stack_count").forGetter(i -> Optional.ofNullable(i.stackCount())), (App)class_5699.field_37408.optionalFieldOf("name_pattern").forGetter(i -> Optional.ofNullable(i.namePattern())), (App)class_2487.field_25128.optionalFieldOf("entity_nbt").forGetter(i -> Optional.ofNullable(i.entityTag)), (App)ColormapExpressionProvider.CODEC.optionalFieldOf("expression").forGetter(i -> Optional.ofNullable(i.expression)), (App)NBT_COMPONENTS_CODEC.optionalFieldOf("item_nbt_components", Map.of()).forGetter(i -> i.nbtMatchers)).apply((Applicative)instance, ItemModelOverride::new));
    public static final Codec<Partial> CODEC_MODEL_ONLY = RecordCodecBuilder.create(instance -> instance.group((App)ModelResHelper.MODEL_RES_CODEC.fieldOf("model").forGetter(Partial::model)).apply((Applicative)instance, Partial::new));

    public ItemModelOverride(Optional<Dynamic<?>> lazyComponent, class_1091 model, Optional<Integer> stackCount, Optional<Pattern> pattern, Optional<class_2487> entityTag, Optional<ColormapExpressionProvider> expression, Map<class_9331<?>, class_2487> nbtMatchers) {
        this.lazyComponent = lazyComponent.orElse(null);
        this.model = model;
        this.stackCount = stackCount.orElse(null);
        this.pattern = pattern.orElse(null);
        this.entityTag = entityTag.orElse(null);
        this.expression = expression.orElse(null);
        this.nbtMatchers = nbtMatchers;
    }

    public ItemModelOverride(class_9323 map, class_1091 model) {
        this.lazyComponent = null;
        this.model = model;
        this.stackCount = null;
        this.pattern = null;
        this.decodedComponents = map;
        this.entityTag = null;
        this.expression = null;
    }

    public class_9323 getComponents(class_7225.class_7874 registryAccess) {
        if (this.decodedComponents == null && this.lazyComponent != null) {
            this.decodedComponents = ItemModelOverride.runCodec(registryAccess, this.lazyComponent);
        }
        return this.decodedComponents;
    }

    private static <T> class_9323 runCodec(class_7225.class_7874 ra, Dynamic<T> dynamic) {
        class_6903 ops = class_6903.method_46632((DynamicOps)dynamic.getOps(), (class_7225.class_7874)ra);
        return (class_9323)((Pair)class_9323.field_50234.decode((DynamicOps)ops, dynamic.getValue()).result().orElseThrow(() -> new JsonParseException("Failed to decode components map"))).getFirst();
    }

    public class_1091 model() {
        return this.model;
    }

    @Nullable
    public Integer stackCount() {
        return this.stackCount;
    }

    @Nullable
    public Pattern namePattern() {
        return this.pattern;
    }

    @Nullable
    public class_2487 entityTag() {
        return this.entityTag;
    }

    public boolean matchesPredicate(class_1799 stack, @Nullable class_1937 level, @Nullable Supplier<class_2487> entityTagGetter, @Nullable class_2561 customName) {
        class_2338 pos;
        class_2487 tag;
        if (this.pattern != null && customName != null && !this.pattern.matcher(customName.getString()).matches()) {
            return false;
        }
        if (this.entityTag != null && entityTagGetter != null && !ItemModelOverride.containsTag(tag = entityTagGetter.get(), this.entityTag)) {
            return false;
        }
        if (this.expression != null && this.expression.getValue(null, pos = ClientFrameTicker.getCameraPos(), null, null, stack) == 0.0f) {
            return false;
        }
        for (Map.Entry<class_9331<?>, class_2487> m : this.nbtMatchers.entrySet()) {
            class_9279 d;
            class_9331<?> type = m.getKey();
            Object c = stack.method_57824(type);
            if (!(c instanceof class_9279) || ItemModelOverride.containsTag((d = (class_9279)c).method_57463(), m.getValue())) continue;
            return false;
        }
        return true;
    }

    private static boolean containsTag(class_2487 tagToMatch, class_2487 entityTag) {
        for (String key : tagToMatch.method_10541()) {
            class_2520 t = entityTag.method_10580(key);
            if (t == null) {
                return false;
            }
            if (t instanceof class_2487) {
                class_2487 ct = (class_2487)t;
                class_2487 compound = tagToMatch.method_10562(key);
                if (compound.method_33133()) {
                    return false;
                }
                if (ItemModelOverride.containsTag(compound, ct)) continue;
                return false;
            }
            if (t.equals((Object)entityTag.method_10580(key))) continue;
            return false;
        }
        return true;
    }

    public record Partial(class_1091 model) {
    }
}

