/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.biome;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeEffectModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;

public class BiomeEffectsManager
extends JsonPartialReloader {
    private final Map<ResourceLocation, BiomeSpecialEffects> vanillaEffects = new HashMap<ResourceLocation, BiomeSpecialEffects>();
    private final Map<ResourceLocation, BiomeEffectModifier> effectsToApply = new HashMap<ResourceLocation, BiomeEffectModifier>();
    private boolean needsDynamicApplication = true;
    private final Map<Biome, BiomeEffectModifier> fogParametersModifiers = new HashMap<Biome, BiomeEffectModifier>();

    public BiomeEffectsManager() {
        super("biome_modifiers", "biome_effects");
    }

    @Override
    public void parseWithLevel(Map<ResourceLocation, JsonElement> jsons, RegistryOps<JsonElement> ops, RegistryAccess access) {
        for (Map.Entry<ResourceLocation, BiomeEffectModifier> v : Parsed.batchParseOnlyEnabled(jsons, BiomeEffectModifier.CODEC, ops, "biome modifier")) {
            this.addEffect(v.getKey(), v.getValue(), access);
        }
    }

    private void addEffect(ResourceLocation pathId, BiomeEffectModifier mod, RegistryAccess access) {
        Registry registry = access.m_175515_(Registries.f_256952_);
        for (Holder biome : mod.targets().compute(pathId, registry)) {
            this.effectsToApply.merge(((ResourceKey)biome.m_203543_().get()).m_135782_(), mod, BiomeEffectModifier::merge);
        }
    }

    @Override
    public void applyWithLevel(RegistryAccess registryAccess, boolean isLogIn) {
        if (!isLogIn && !this.needsDynamicApplication) {
            return;
        }
        this.needsDynamicApplication = false;
        if (isLogIn) {
            this.vanillaEffects.clear();
        }
        Registry biomeReg = (Registry)registryAccess.m_6632_(Registries.f_256952_).get();
        for (Map.Entry<ResourceLocation, BiomeEffectModifier> v : this.effectsToApply.entrySet()) {
            ResourceLocation biomeId = v.getKey();
            BiomeEffectModifier modifier = v.getValue();
            Optional biome = biomeReg.m_6612_(biomeId);
            if (!biome.isPresent()) continue;
            BiomeSpecialEffects old = modifier.apply((Biome)biome.get());
            this.vanillaEffects.put(biomeId, old);
            if (!modifier.modifyFogParameter()) continue;
            this.fogParametersModifiers.put((Biome)biome.get(), modifier);
        }
        if (!this.vanillaEffects.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Biome Effects Properties", (Object)this.vanillaEffects.size());
        }
    }

    @Override
    public void resetWithLevel(boolean isLogOff) {
        this.needsDynamicApplication = true;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            Registry biomeReg = (Registry)level.m_9598_().m_6632_(Registries.f_256952_).get();
            for (Map.Entry<ResourceLocation, BiomeSpecialEffects> v : this.vanillaEffects.entrySet()) {
                Optional biome = biomeReg.m_6612_(v.getKey());
                biome.ifPresent(bio -> BiomeEffectModifier.applyEffects(bio, (BiomeSpecialEffects)v.getValue()));
            }
        }
        this.vanillaEffects.clear();
        this.effectsToApply.clear();
        this.fogParametersModifiers.clear();
    }

    public BiomeEffectModifier getFogModifier(Biome value) {
        return this.fogParametersModifiers.get(value);
    }
}

