/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.mehvahdjukaar.polytone.utils.CodecUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BlockOffsets {
    public static final Codec<BlockBehaviour.OffsetFunction> CODEC = CodecUtil.withAlternative(TypeOffset.CODEC, CustomOffset.CODEC);

    private record TypeOffset(BlockBehaviour.OffsetType type, BlockBehaviour.OffsetFunction inner) implements BlockBehaviour.OffsetFunction
    {
        public static final Codec<TypeOffset> CODEC = Codec.STRING.xmap(s -> {
            try {
                return BlockBehaviour.OffsetType.valueOf((String)s.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                return BlockBehaviour.OffsetType.NONE;
            }
        }, i -> i.name().toLowerCase(Locale.ROOT)).xmap(TypeOffset::new, TypeOffset::type);

        private TypeOffset(BlockBehaviour.OffsetType type) {
            this(type, BlockBehaviour.Properties.m_284310_().m_222979_((BlockBehaviour.OffsetType)type).f_271289_.orElse((a, b, c) -> Vec3.f_82478_));
        }

        public Vec3 m_271794_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
            return this.inner.m_271794_(blockState, blockGetter, blockPos);
        }
    }

    private record CustomOffset(float maxX, float maxY, float maxZ) implements BlockBehaviour.OffsetFunction
    {
        public static final Codec<CustomOffset> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("max_x").orElse((Object)Float.valueOf(0.25f)).forGetter(CustomOffset::maxX), (App)Codec.FLOAT.fieldOf("max_y").orElse((Object)Float.valueOf(0.2f)).forGetter(CustomOffset::maxY), (App)Codec.FLOAT.fieldOf("max_z").orElse((Object)Float.valueOf(0.25f)).forGetter(CustomOffset::maxZ)).apply((Applicative)instance, CustomOffset::new));

        public Vec3 m_271794_(BlockState blockState, BlockGetter getter, BlockPos blockPos) {
            long seed = Mth.m_14130_((int)blockPos.m_123341_(), (int)0, (int)blockPos.m_123343_());
            double verticalOff = ((double)((float)(seed >> 4 & 0xFL) / 15.0f) - 1.0) * (double)this.maxY;
            double xOff = Mth.m_14008_((double)(((double)((float)(seed & 0xFL) / 15.0f) - 0.5) * 0.5), (double)(-this.maxX), (double)this.maxX);
            double zOff = Mth.m_14008_((double)(((double)((float)(seed >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5), (double)(-this.maxZ), (double)this.maxZ);
            return new Vec3(xOff, verticalOff, zOff);
        }
    }
}

