/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.color;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.color.MapColorHelper;
import net.mehvahdjukaar.polytone.mixins.accessor.DustParticleOptionAccessor;
import net.mehvahdjukaar.polytone.mixins.accessor.SheepAccessor;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.SimpleColor;
import net.mehvahdjukaar.polytone.utils.SingleJsonOrPropertiesReloadListener;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ColorManager
extends SingleJsonOrPropertiesReloadListener {
    private final Object2IntMap<MapColor> vanillaMapColors = new Object2IntOpenHashMap();
    private final Map<DyeColor, Integer> vanillaFireworkColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    private final Map<DyeColor, Integer> vanillaDiffuseColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    private final Map<DyeColor, Integer> vanillaTextColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    private final Map<ChatFormatting, Integer> vanillaChatFormatting = new EnumMap<ChatFormatting, Integer>(ChatFormatting.class);
    private final Object2IntMap<SpawnEggItem> vanillaEggsBackgrounds = new Object2IntOpenHashMap();
    private final Object2IntMap<SpawnEggItem> vanillaEggsHighlight = new Object2IntOpenHashMap();
    private final Object2IntMap<MobEffect> vanillaEffectColors = new Object2IntOpenHashMap();
    private final Map<DyeColor, Integer> customSheepColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    protected final List<Vec3> originalRedstoneWireColors = Arrays.stream(RedStoneWireBlock.f_55506_).toList();
    @Nullable
    private BlockContextExpression xpOrbColor;
    @Nullable
    private BlockContextExpression xpOrbColorR;
    @Nullable
    private BlockContextExpression xpOrbColorG;
    @Nullable
    private BlockContextExpression xpOrbColorB;
    private int emptyPotion = 0xF800F8;
    private int waterBottle = 3694022;
    private Integer xpBar = null;
    private Integer splash = null;
    private Integer enchantTableXp = null;
    private SimpleColor fishingLineColor = new SimpleColor(0, 0, 0, 255);
    private Vector3f fishingLineOffset = new Vector3f(0.0f, 0.0f, 0.0f);

    public ColorManager() {
        super("color.properties", "colors.json", new String[]{"polytone", "colormatic", "vanadium", "optifine"});
    }

    public int getEmptyPot() {
        return this.emptyPotion;
    }

    public int getWaterBottle() {
        return this.waterBottle;
    }

    public Integer getXpBar() {
        return this.xpBar;
    }

    public Integer getSplash() {
        return this.splash;
    }

    @Override
    protected void parseWithLevel(Map<ResourceLocation, Properties> properties, RegistryOps<JsonElement> ops, RegistryAccess access) {
        ArrayList<ResourceLocation> keySet = new ArrayList<ResourceLocation>(properties.keySet());
        Lists.reverse(keySet);
        for (ResourceLocation k : keySet) {
            Properties p = properties.get(k);
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                Object object = e.getKey();
                if (!(object instanceof String)) continue;
                String key = (String)object;
                String[] split = key.split("\\.");
                try {
                    this.parseColor(split, e.getValue(), k);
                }
                catch (Exception e1) {
                    Polytone.LOGGER.error("Failed to parse color property {} in file {}", (Object)key, (Object)k);
                }
            }
        }
        this.regenSheepColors();
    }

    private void parseColor(String[] prop, Object obj, ResourceLocation colorPropFileId) {
        if (!(obj instanceof String)) {
            return;
        }
        String str = (String)obj;
        if (this.is(prop, 0, "map")) {
            String name = this.get(prop, 1);
            MapColor color = MapColorHelper.byName(name);
            if (color != null) {
                int col = ColorManager.parseHex(obj);
                if (!this.vanillaMapColors.containsKey((Object)color)) {
                    this.vanillaMapColors.put((Object)color, color.f_283871_);
                }
                color.f_283871_ = col;
            } else {
                Polytone.LOGGER.warn("Unknown MapColor with name {}", (Object)name);
            }
        } else if (this.is(prop, 0, "dye")) {
            String name = this.get(prop, 1);
            DyeColor color = DyeColor.m_41057_((String)name, null);
            if (color != null) {
                String param = this.get(prop, 2);
                int col = ColorManager.parseHex(obj);
                if (param == null || param.equals("diffuse")) {
                    if (!this.vanillaDiffuseColors.containsKey(color)) {
                        this.vanillaDiffuseColors.put(color, ColorUtils.pack(color.f_41039_));
                    }
                    color.f_41039_ = ColorUtils.unpack(col);
                } else if (param.equals("firework")) {
                    if (!this.vanillaFireworkColors.containsKey(color)) {
                        this.vanillaFireworkColors.put(color, color.f_41040_);
                    }
                    color.f_41040_ = col;
                } else if (param.equals("text")) {
                    if (!this.vanillaTextColors.containsKey(color)) {
                        this.vanillaTextColors.put(color, color.f_41041_);
                    }
                    color.f_41041_ = col;
                }
            } else {
                Polytone.LOGGER.warn("Unknown DyeColor with name {}", (Object)name);
            }
        } else if (this.is(prop, 0, "fishing_line")) {
            if (this.is(prop, 1, "color")) {
                this.fishingLineColor = new SimpleColor(ColorManager.parseHex(obj));
            } else if (this.is(prop, 1, "offset")) {
                if (this.is(prop, 2, "x")) {
                    this.fishingLineOffset.x = Integer.parseInt(str);
                } else if (this.is(prop, 2, "y")) {
                    this.fishingLineOffset.y = Integer.parseInt(str);
                } else if (this.is(prop, 2, "z")) {
                    this.fishingLineOffset.z = Integer.parseInt(str);
                }
            }
        } else if (this.is(prop, 0, "enchant_table")) {
            if (this.is(prop, 1, "xp")) {
                this.enchantTableXp = ColorManager.parseHex(obj);
            }
        } else if (this.is(prop, 0, "particle")) {
            if (prop.length > 1) {
                String s = prop[1];
                ResourceLocation id = new ResourceLocation(s.replace("\\", ""));
                try {
                    int hex = ColorManager.parseHex(str);
                    Polytone.PARTICLE_MODIFIERS.addCustomParticleColor(id, String.valueOf(hex));
                }
                catch (Exception e) {
                    Polytone.PARTICLE_MODIFIERS.addCustomParticleColor(id, str);
                }
            }
        } else if (this.is(prop, 0, "egg")) {
            if (prop.length > 2) {
                EntityType entity;
                ResourceLocation id = new ResourceLocation(prop[2].replace("\\", ""));
                Item item = BuiltInRegistries.f_257033_.m_6612_(id).orElse(null);
                if (item == null && (entity = (EntityType)BuiltInRegistries.f_256780_.m_6612_(id).orElse(null)) != null) {
                    item = SpawnEggItem.m_43213_((EntityType)entity);
                }
                if (item == null) {
                    item = BuiltInRegistries.f_257033_.m_6612_(id.m_266382_("_spawn_egg")).orElse(null);
                }
                if (item instanceof SpawnEggItem) {
                    SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                    int col = ColorManager.parseHex(obj);
                    if (this.is(prop, 1, "shell")) {
                        if (!this.vanillaEggsBackgrounds.containsKey((Object)spawnEggItem)) {
                            this.vanillaEggsBackgrounds.put((Object)spawnEggItem, spawnEggItem.f_151200_);
                        }
                        spawnEggItem.f_151200_ = col;
                    } else if (this.is(prop, 1, "spots")) {
                        if (!this.vanillaEggsHighlight.containsKey((Object)spawnEggItem)) {
                            this.vanillaEggsHighlight.put((Object)spawnEggItem, spawnEggItem.f_151201_);
                        }
                        spawnEggItem.f_151201_ = col;
                    }
                } else {
                    Polytone.LOGGER.warn("Unknown or invalid Spawn Egg Item with name {}", (Object)id);
                }
            }
        } else if (this.is(prop, 0, "potion") || this.is(prop, 0, "effect")) {
            ResourceLocation id = new ResourceLocation(prop[1].replace("\\", ""));
            int col = ColorManager.parseHex(obj);
            if (id.m_135815_().equals("empty")) {
                this.emptyPotion = col;
            } else if (id.m_135815_().equals("water")) {
                this.waterBottle = col;
            } else {
                MobEffect effect = BuiltInRegistries.f_256974_.m_6612_(id).orElse(null);
                if (effect != null) {
                    if (!this.vanillaEffectColors.containsKey((Object)effect)) {
                        this.vanillaEffectColors.put((Object)effect, effect.m_19484_());
                    }
                    effect.f_19448_ = col;
                } else {
                    Polytone.LOGGER.warn("Unknown Mob Effect with name {}", (Object)id);
                }
            }
        } else if (this.is(prop, 0, "sheep")) {
            String name = this.get(prop, 1);
            DyeColor color = DyeColor.m_41057_((String)name, null);
            if (color != null) {
                int col = ColorManager.parseHex(obj);
                this.customSheepColors.put(color, col);
            } else {
                Polytone.LOGGER.warn("Unknown Dye Color with name {}", (Object)name);
            }
        } else if (this.is(prop, 0, "xporb")) {
            if (this.is(prop, 1, "color")) {
                this.xpOrbColor = new BlockContextExpression(str);
            } else if (this.is(prop, 1, "red")) {
                this.xpOrbColorR = new BlockContextExpression(str);
            } else if (this.is(prop, 1, "green")) {
                this.xpOrbColorG = new BlockContextExpression(str);
            } else if (this.is(prop, 1, "blue")) {
                this.xpOrbColorB = new BlockContextExpression(str);
            }
        } else if (this.is(prop, 0, "redstone")) {
            String ind = this.get(prop, 1);
            if (ind != null) {
                int code = Integer.parseInt(ind);
                if (code < RedStoneWireBlock.f_55506_.length) {
                    int col = ColorManager.parseHex(obj);
                    float[] rgb = ColorUtils.unpack(col);
                    RedStoneWireBlock.f_55506_[code] = new Vec3((double)rgb[0], (double)rgb[1], (double)rgb[2]);
                    if (code == 15) {
                        Vector3f maxPower;
                        DustParticleOptions.f_175788_ = maxPower = new Vector3f(rgb[0], rgb[1], rgb[2]);
                        ((DustParticleOptionAccessor)DustParticleOptions.f_123656_).setColor(maxPower);
                    }
                } else {
                    Polytone.LOGGER.warn("Redstone color index must be between 0 and 15");
                }
            }
        } else if (this.is(prop, 0, "text")) {
            int col = ColorManager.parseHex(obj);
            ChatFormatting text = null;
            if (this.is(prop, 1, "splash")) {
                this.splash = col;
            } else if (this.is(prop, 1, "xpbar")) {
                this.xpBar = col;
            } else if (this.is(prop, 1, "code")) {
                s = this.get(prop, 2);
                if (s != null) {
                    int code = Integer.parseInt(s);
                    text = ChatFormatting.m_126647_((int)code);
                }
            } else {
                s = this.get(prop, 1);
                text = ChatFormatting.m_126657_((String)s);
            }
            if (text != null) {
                if (!this.vanillaChatFormatting.containsKey(text)) {
                    this.vanillaChatFormatting.put(text, text.m_126665_());
                }
                text.f_126595_ = col;
                TextColor tc = TextColor.m_131270_(text);
                tc.f_131257_ = col;
            }
        } else if (this.is(prop, 0, "palette") && this.is(prop, 1, "block") && prop.length > 2 && obj instanceof String) {
            String path = prop[2].replace("~/colormap/", colorPropFileId.m_135827_() + ":");
            Polytone.BLOCK_MODIFIERS.addSimpleColormap(new ResourceLocation(path), str);
        }
    }

    private boolean is(String[] array, int index, String value) {
        if (array.length <= index) {
            return false;
        }
        return array[index].equals(value);
    }

    @Nullable
    private String get(String[] array, int index) {
        if (array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Nullable
    private <T> T get(String[] array, int index, Function<String, T> fun) {
        if (array.length <= index) {
            return null;
        }
        return fun.apply(array[index]);
    }

    private static int parseHex(Object obj) {
        if (obj instanceof String) {
            Object value = (String)obj;
            if (((String)(value = ((String)value).replace("#", "").replace("0x", "").trim())).length() == 6) {
                value = "FF" + (String)value;
            } else if (((String)value).length() != 8) {
                throw new JsonParseException("Invalid color format: " + (String)value);
            }
            return (int)Long.parseLong((String)value, 16);
        }
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            return i;
        }
        throw new JsonParseException("Failed to parse object " + String.valueOf(obj) + ". Expected a hex String or Integer");
    }

    @Override
    protected void applyWithLevel(RegistryAccess access, boolean isLogIn) {
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        SpawnEggItem item;
        MapColor color;
        this.emptyPotion = 0xF800F8;
        this.waterBottle = 3694022;
        this.xpBar = null;
        this.xpOrbColor = null;
        this.xpOrbColorR = null;
        this.xpOrbColorG = null;
        this.xpOrbColorB = null;
        this.fishingLineOffset = new Vector3f();
        this.fishingLineColor = new SimpleColor(0, 0, 0, 255);
        this.enchantTableXp = null;
        for (Map.Entry entry : this.vanillaMapColors.entrySet()) {
            color = (MapColor)entry.getKey();
            color.f_283871_ = (Integer)entry.getValue();
        }
        this.vanillaMapColors.clear();
        for (Map.Entry entry : this.vanillaDiffuseColors.entrySet()) {
            color = (DyeColor)entry.getKey();
            color.f_41039_ = ColorUtils.unpack((Integer)entry.getValue());
        }
        this.vanillaDiffuseColors.clear();
        for (Map.Entry entry : this.vanillaFireworkColors.entrySet()) {
            color = (DyeColor)entry.getKey();
            color.f_41040_ = (Integer)entry.getValue();
        }
        this.vanillaFireworkColors.clear();
        for (Map.Entry entry : this.vanillaTextColors.entrySet()) {
            color = (DyeColor)entry.getKey();
            color.f_41041_ = (Integer)entry.getValue();
        }
        this.vanillaTextColors.clear();
        for (Map.Entry entry : this.vanillaChatFormatting.entrySet()) {
            ChatFormatting text = (ChatFormatting)entry.getKey();
            text.f_126595_ = (Integer)entry.getValue();
            TextColor tc = TextColor.m_131270_((ChatFormatting)text);
            tc.f_131257_ = (Integer)entry.getValue();
        }
        for (Map.Entry entry : this.vanillaEggsBackgrounds.entrySet()) {
            item = (SpawnEggItem)entry.getKey();
            item.f_151200_ = (Integer)entry.getValue();
        }
        this.vanillaEggsBackgrounds.clear();
        for (Map.Entry entry : this.vanillaEggsHighlight.entrySet()) {
            item = (SpawnEggItem)entry.getKey();
            item.f_151201_ = (Integer)entry.getValue();
        }
        this.vanillaEggsHighlight.clear();
        RedStoneWireBlock.f_55506_ = this.originalRedstoneWireColors.toArray(new Vec3[0]);
        DustParticleOptions.f_175788_ = new Vector3f(1.0f, 0.0f, 0.0f);
        ((DustParticleOptionAccessor)DustParticleOptions.f_123656_).setColor(DustParticleOptions.f_175788_);
    }

    public void regenSheepColors() {
        Sheep.f_29801_ = new EnumMap(DyeColor.class);
        for (DyeColor d : DyeColor.values()) {
            Sheep.f_29801_.put(d, SheepAccessor.invokeCreateSheepColor(d));
        }
        for (Map.Entry entry : this.customSheepColors.entrySet()) {
            Sheep.f_29801_.put((DyeColor)entry.getKey(), ColorUtils.unpack((Integer)entry.getValue()));
        }
        this.customSheepColors.clear();
    }

    public float @Nullable [] getXpOrbColor(ExperienceOrb orb, float partialTicks) {
        float time = (float)orb.f_19797_ + partialTicks;
        Level level = orb.m_9236_();
        Vec3 position = orb.m_20182_();
        if (this.xpOrbColor != null) {
            int color = (int)this.xpOrbColor.getValue(position, time, level);
            return ColorUtils.unpack(color);
        }
        if (this.xpOrbColorR == null && this.xpOrbColorG == null && this.xpOrbColorB == null) {
            return null;
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (this.xpOrbColorR != null) {
            r = (float)this.xpOrbColorR.getValue(position, time, level);
        }
        if (this.xpOrbColorG != null) {
            g = (float)this.xpOrbColorG.getValue(position, time, level);
        }
        if (this.xpOrbColorB != null) {
            b = (float)this.xpOrbColorB.getValue(position, time, level);
        }
        return new float[]{r, g, b};
    }

    public SimpleColor getFishingLineColor() {
        return this.fishingLineColor;
    }

    public Vector3f getFishingLineOffset() {
        return this.fishingLineOffset;
    }
}

