/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.utils.CodecUtil;
import net.mehvahdjukaar.polytone.utils.codec.CodecUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BiomeCompoundColorGetter
implements IColorGetter {
    public static final Codec<BiomeCompoundColorGetter> CODEC = CodecUtil.validate(RecordCodecBuilder.create(i -> i.group((App)Colormap.REFERENCE_OR_EXPRESSION.fieldOf("default").forGetter(c -> c.defaultGetter), (App)CodecUtils.lenientUnboundedMap(RegistryFixedCodec.m_206740_((ResourceKey)Registries.f_256952_), Colormap.REFERENCE_OR_EXPRESSION).fieldOf("biomes").forGetter(c -> c.holderMap)).apply((Applicative)i, BiomeCompoundColorGetter::new)), c -> {
        if (c.getters.isEmpty()) {
            return DataResult.error(() -> "Must have at least 1 tint getter");
        }
        for (IColorGetter a : c.getters.values()) {
            if (!a.needsToFillTexture()) continue;
            return DataResult.error(() -> "Biome compound colormap only works on BY_REFERENCE colormaps defined in the colormap folder");
        }
        if (c.defaultGetter.needsToFillTexture()) {
            return DataResult.error(() -> "Biome compound colormap only works on BY_REFERENCE colormaps defined in the colormap folder");
        }
        return DataResult.success((Object)c);
    });
    private final Map<Biome, IColorGetter> getters = new HashMap<Biome, IColorGetter>();
    private final Map<Holder<Biome>, IColorGetter> holderMap;
    private final IColorGetter defaultGetter;

    public BiomeCompoundColorGetter(IColorGetter defaultGetter, Map<Holder<Biome>, IColorGetter> map) {
        for (Map.Entry<Holder<Biome>, IColorGetter> e : map.entrySet()) {
            this.getters.put((Biome)e.getKey().m_203334_(), e.getValue());
        }
        this.holderMap = map;
        this.defaultGetter = defaultGetter;
    }

    @Override
    public boolean needsToFillTexture() {
        return false;
    }

    public int m_92566_(BlockState blockState, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int i) {
        LevelReader l;
        Biome biome;
        IColorGetter g;
        if (level instanceof LevelReader && (g = this.getters.get(biome = (Biome)(l = (LevelReader)level).m_204166_(pos).m_203334_())) != null) {
            return g.m_92566_(blockState, level, pos, i);
        }
        return this.defaultGetter.m_92566_(blockState, level, pos, i);
    }

    public int m_92671_(ItemStack itemStack, int i) {
        return this.defaultGetter.m_92671_(itemStack, i);
    }

    @Override
    public IColorGetter makeConcurrent() {
        HashMap<Holder<Biome>, IColorGetter> map = new HashMap<Holder<Biome>, IColorGetter>();
        for (Map.Entry<Holder<Biome>, IColorGetter> e : this.holderMap.entrySet()) {
            map.put(e.getKey(), e.getValue().makeConcurrent());
        }
        return new BiomeCompoundColorGetter(this.defaultGetter.makeConcurrent(), map);
    }

    @Override
    public int sampleColor(@Nullable BlockState state, @Nullable BlockPos pos, @Nullable Biome biome, @Nullable ItemStack item) {
        IColorGetter g;
        if (biome != null && (g = this.getters.get(biome)) != null) {
            return g.sampleColor(state, pos, biome, item);
        }
        return this.defaultGetter.sampleColor(state, pos, biome, item);
    }
}

