/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.dimension.DimensionTarget;
import net.mehvahdjukaar.polytone.lightmap.Lightmap;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public record DimensionEffectsModifier(Optional<Either<Float, BlockContextExpression>> cloudLevel, Optional<Boolean> hasGround, Optional<DimensionSpecialEffects.SkyType> skyType, Optional<Boolean> forceBrightLightmap, Optional<Boolean> constantAmbientLight, Optional<IColorGetter> fogColor, Optional<IColorGetter> skyColor, Optional<IColorGetter> sunsetColor, boolean noWeatherFogDarken, boolean noWeatherSkyDarken, Optional<Lightmap> lightmap, DimensionTarget targets) {
    public static final Codec<DimensionSpecialEffects.SkyType> SKY_TYPE_CODEC = Codec.STRING.xmap(DimensionSpecialEffects.SkyType::valueOf, Enum::name);
    public static final Decoder<DimensionEffectsModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(Codec.either((Codec)Codec.FLOAT, BlockContextExpression.CODEC), "cloud_level").forGetter(DimensionEffectsModifier::cloudLevel), (App)StrOpt.of(Codec.BOOL, "has_ground").forGetter(DimensionEffectsModifier::hasGround), (App)StrOpt.of(SKY_TYPE_CODEC, "sky_type").forGetter(DimensionEffectsModifier::skyType), (App)StrOpt.of(Codec.BOOL, "force_bright_lightmap").forGetter(DimensionEffectsModifier::forceBrightLightmap), (App)StrOpt.of(Codec.BOOL, "constant_ambient_light").forGetter(DimensionEffectsModifier::constantAmbientLight), (App)StrOpt.of(Colormap.CODEC, "fog_colormap").forGetter(DimensionEffectsModifier::fogColor), (App)StrOpt.of(Colormap.CODEC, "sky_colormap").forGetter(DimensionEffectsModifier::skyColor), (App)StrOpt.of(Colormap.CODEC, "sunset_colormap").forGetter(DimensionEffectsModifier::sunsetColor), (App)StrOpt.of(Codec.BOOL, "no_weather_fog_darken", false).forGetter(DimensionEffectsModifier::noWeatherFogDarken), (App)StrOpt.of(Codec.BOOL, "no_weather_sky_darken", false).forGetter(DimensionEffectsModifier::noWeatherSkyDarken), (App)StrOpt.of(Polytone.LIGHTMAPS.byNameCodec(), "lightmap").forGetter(DimensionEffectsModifier::lightmap), (App)DimensionTarget.CODEC.optionalFieldOf("targets", (Object)DimensionTarget.EMPTY).forGetter(DimensionEffectsModifier::targets)).apply((Applicative)instance, DimensionEffectsModifier::new));

    public static DimensionEffectsModifier ofFogColor(Colormap colormap) {
        return new DimensionEffectsModifier(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(colormap), Optional.empty(), Optional.empty(), false, false, Optional.empty(), DimensionTarget.EMPTY);
    }

    public static DimensionEffectsModifier ofSkyColor(Colormap colormap) {
        return new DimensionEffectsModifier(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(colormap), Optional.empty(), false, false, Optional.empty(), DimensionTarget.EMPTY);
    }

    public static DimensionEffectsModifier ofSunsetColor(Colormap colormap) {
        return new DimensionEffectsModifier(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(colormap), false, false, Optional.empty(), DimensionTarget.EMPTY);
    }

    public DimensionEffectsModifier merge(DimensionEffectsModifier newMod) {
        return new DimensionEffectsModifier(newMod.cloudLevel.isPresent() ? newMod.cloudLevel : this.cloudLevel, newMod.hasGround.isPresent() ? newMod.hasGround : this.hasGround, newMod.skyType.isPresent() ? newMod.skyType : this.skyType, newMod.forceBrightLightmap.isPresent() ? newMod.forceBrightLightmap : this.forceBrightLightmap, newMod.constantAmbientLight.isPresent() ? newMod.constantAmbientLight : this.constantAmbientLight, newMod.fogColor.isPresent() ? newMod.fogColor : this.fogColor, newMod.skyColor.isPresent() ? newMod.skyColor : this.skyColor, newMod.sunsetColor.isPresent() ? newMod.sunsetColor : this.sunsetColor, newMod.noWeatherFogDarken | this.noWeatherFogDarken, newMod.noWeatherSkyDarken | this.noWeatherSkyDarken, newMod.lightmap.isPresent() ? newMod.lightmap : this.lightmap, newMod.targets);
    }

    @Nullable
    public BlockColor getFogColormap() {
        return this.fogColor.orElse(null);
    }

    @Nullable
    public BlockColor getSkyColormap() {
        return this.skyColor.orElse(null);
    }

    @Nullable
    public BlockColor getSunsetColormap() {
        return this.sunsetColor.orElse(null);
    }

    public DimensionEffectsModifier applyInplace(ResourceLocation dimensionId) {
        DimensionSpecialEffects effects = PlatStuff.getDimensionEffects(dimensionId);
        Optional<Either<Float, BlockContextExpression>> oldCloud = Optional.empty();
        if (this.cloudLevel.isPresent() && this.cloudLevel.get().left().isPresent()) {
            oldCloud = Optional.of(Either.left((Object)Float.valueOf(effects.f_108859_)));
            effects.f_108859_ = ((Float)this.cloudLevel.get().left().get()).floatValue();
        }
        Optional<Boolean> oldGround = Optional.empty();
        if (this.hasGround.isPresent()) {
            oldGround = Optional.of(effects.f_108860_);
            effects.f_108860_ = this.hasGround.get();
        }
        Optional<DimensionSpecialEffects.SkyType> oldSky = Optional.empty();
        if (this.skyType.isPresent()) {
            oldSky = Optional.of(effects.f_108861_);
            effects.f_108861_ = this.skyType.get();
        }
        Optional<Boolean> oldBright = Optional.empty();
        if (this.forceBrightLightmap.isPresent()) {
            oldBright = Optional.of(effects.f_108862_);
            effects.f_108862_ = this.forceBrightLightmap.get();
        }
        Optional<Boolean> oldAmbient = Optional.empty();
        if (this.constantAmbientLight.isPresent()) {
            oldAmbient = Optional.of(effects.f_108863_);
            effects.f_108863_ = this.constantAmbientLight.get();
        }
        return new DimensionEffectsModifier(oldCloud, oldGround, oldSky, oldBright, oldAmbient, Optional.empty(), Optional.empty(), Optional.empty(), false, false, Optional.empty(), DimensionTarget.EMPTY);
    }
}

