/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.forge;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.item.IPolytoneItem;
import net.mehvahdjukaar.polytone.item.ItemModifier;
import net.mehvahdjukaar.polytone.slotify.SlotifyScreen;
import net.mehvahdjukaar.polytone.tabs.ItemToTabEvent;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.FogManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod(value="polytone")
public class PolytoneForge {
    public static final Logger LOGGER = LogManager.getLogger((String)"Polytone");

    public PolytoneForge() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            boolean iris = ModList.get().isLoaded("iris") || ModList.get().isLoaded("oculus");
            Polytone.init(false, !FMLEnvironment.production, true, iris);
            MinecraftForge.EVENT_BUS.register((Object)this);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.LOWEST, this::modifyCreativeTabs);
        } else {
            LOGGER.warn("Slotify has been installed on a server. This wont cause issues but mod wont do anything here as its a client mod");
        }
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent onRender) {
        if (onRender.phase == TickEvent.Phase.START) {
            ClientFrameTicker.onRenderTick(Minecraft.m_91087_());
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ClientFrameTicker.onTick(event.level);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onTooltip(ItemTooltipEvent tooltipEvent) {
        ItemModifier mod = ((IPolytoneItem)tooltipEvent.getItemStack().m_41720_()).polytone$getModifier();
        if (mod != null) {
            mod.modifyTooltips(tooltipEvent.getToolTip());
        }
    }

    @SubscribeEvent
    public void onTagSync(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED) {
            Polytone.onTagsReceived(event.getRegistryAccess());
        }
    }

    @SubscribeEvent
    public void renderScreen(ScreenEvent.Render.Post event) {
        Screen screen = event.getScreen();
        SlotifyScreen ss = (SlotifyScreen)screen;
        if (ss.polytone$hasSprites()) {
            GuiGraphics graphics = event.getGuiGraphics();
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)screen.f_96543_ / 2.0f, (float)screen.f_96544_ / 2.0f, 500.0f);
            ss.polytone$renderExtraSprites(graphics);
            poseStack.m_85849_();
        }
    }

    @SubscribeEvent
    public void onLevelUnload(ClientPlayerNetworkEvent.LoggingOut event) {
        Polytone.onLoggedOut();
    }

    @SubscribeEvent
    public void fogEvent(ViewportEvent.RenderFog fogEvent) {
        if (fogEvent.getType() != FogType.NONE || fogEvent.getMode() != FogRenderer.FogMode.FOG_TERRAIN) {
            return;
        }
        FogManager.FogState targetFog = FogManager.modifyBiomeFog(fogEvent.getNearPlaneDistance(), fogEvent.getFarPlaneDistance());
        if (targetFog != null) {
            fogEvent.setNearPlaneDistance(targetFog.start());
            fogEvent.setFarPlaneDistance(targetFog.end());
            fogEvent.setCanceled(true);
        }
    }

    public void modifyCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        Polytone.CREATIVE_TABS_MODIFIERS.modifyTab(new ItemToTabEventImpl(event));
    }

    public record ItemToTabEventImpl(BuildCreativeModeTabContentsEvent event) implements ItemToTabEvent
    {
        @Override
        public ResourceKey<CreativeModeTab> getTab() {
            return this.event.getTabKey();
        }

        @Override
        public void removeItems(Predicate<ItemStack> target) {
            Iterator iter = this.event.getEntries().iterator();
            while (iter.hasNext()) {
                Map.Entry e = (Map.Entry)iter.next();
                if (!target.test((ItemStack)e.getKey())) continue;
                iter.remove();
            }
        }

        @Override
        public void addItems(@Nullable Predicate<ItemStack> target, boolean after, List<ItemStack> items) {
            if (target == null) {
                this.event.m_246601_(items);
            } else {
                MutableHashedLinkedMap entries = this.event.getEntries();
                ItemStack lastValid = null;
                for (Map.Entry e : entries) {
                    ItemStack item = (ItemStack)e.getKey();
                    if (!item.m_246617_(this.event.getFlags())) continue;
                    boolean isValid = target.test(item);
                    if (after && lastValid != null && !isValid) {
                        List rev = Lists.reverse(new ArrayList<ItemStack>(items));
                        for (ItemStack ni2 : rev) {
                            entries.putAfter((Object)lastValid, (Object)ni2, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                        }
                        return;
                    }
                    if (isValid) {
                        lastValid = item;
                    }
                    if (after || !isValid) continue;
                    items.forEach(ni -> entries.putBefore((Object)item, ni, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
                    return;
                }
                for (ItemStack ni3 : items) {
                    entries.put((Object)ni3, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            }
        }
    }
}

