/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.lightmap;

import com.mojang.serialization.Codec;
import net.mehvahdjukaar.polytone.lightmap.LightmapExpressionProvider;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.mehvahdjukaar.polytone.utils.codec.CodecUtils;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public interface ILightmapNumberProvider {
    public static final MapRegistry<ILightmapNumberProvider> BUILTIN_PROVIDERS = new MapRegistry("Lightmap Number Providers");
    public static final Codec<ILightmapNumberProvider> CODEC = CodecUtils.referenceOrDirect(BUILTIN_PROVIDERS, LightmapExpressionProvider.CODEC, true);
    public static final RandomSource RAND = RandomSource.m_216327_();
    public static final ILightmapNumberProvider RANDOM = BUILTIN_PROVIDERS.register("random", (time, rain, thunder) -> {
        RAND.m_188584_((long)Float.floatToIntBits(time));
        return RAND.m_188501_();
    });
    public static final ILightmapNumberProvider DEFAULT = BUILTIN_PROVIDERS.register("default", (time, rain, thunder) -> {
        float g = 1.0f - (Mth.m_14089_((float)(time * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        g = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
        g = 1.0f - g;
        return g;
    });
    public static final ILightmapNumberProvider SMOOTH = BUILTIN_PROVIDERS.register("smooth", (time, rain, thunder) -> 0.5f + Mth.m_14089_((float)(time * ((float)Math.PI * 2))) * 0.5f);
    public static final ILightmapNumberProvider LINEAR = BUILTIN_PROVIDERS.register("linear", (time, rain, thunder) -> Mth.m_14154_((float)(1.0f - 2.0f * time)));
    public static final ILightmapNumberProvider DEFAULT_2 = BUILTIN_PROVIDERS.register("default_2", (time, rain, thunder) -> {
        float g = 1.0f - (Mth.m_14089_((float)(time * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        g = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
        g = 1.0f - g;
        g = (float)((double)g * 0.5);
        if ((double)time > 0.5) {
            return g;
        }
        return 1.0f - g;
    });
    public static final ILightmapNumberProvider SMOOTH_2 = BUILTIN_PROVIDERS.register("smooth_2", (time, rain, thunder) -> {
        if ((double)time > 0.5) {
            return 0.25f - Mth.m_14089_((float)(time * ((float)Math.PI * 2))) * 0.25f;
        }
        return 0.75f + Mth.m_14089_((float)(time * ((float)Math.PI * 2))) * 0.25f;
    });
    public static final ILightmapNumberProvider LINEAR_2 = BUILTIN_PROVIDERS.register("linear_2", (time, rain, thunder) -> {
        float linear = Mth.m_14154_((float)(1.0f - 2.0f * time));
        if ((double)time > 0.5) {
            return linear * 0.5f;
        }
        return 1.0f - linear * 0.5f;
    });

    public float getValue(float var1, float var2, float var3);
}

