/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.particle.CustomParticleType;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.mehvahdjukaar.polytone.utils.exp.IExpression;
import net.mehvahdjukaar.polytone.utils.exp.PolytoneExpression;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public class ParticleContextExpression
extends PolytoneExpression {
    private static final String COLOR = "COLOR";
    private static final String SPEED = "SPEED";
    private static final String X = "X";
    private static final String Y = "Y";
    private static final String Z = "Z";
    private static final String DX = "DX";
    private static final String DY = "DY";
    private static final String DZ = "DZ";
    private static final String RED = "RED";
    private static final String GREEN = "GREEN";
    private static final String BLUE = "BLUE";
    private static final String ALPHA = "ALPHA";
    private static final String SIZE = "SIZE";
    private static final String LIFE = "LIFETIME";
    private static final String AGE = "AGE";
    private static final String ROLL = "ROLL";
    private static final String CUSTOM = "CUSTOM";
    public static final Codec<ParticleContextExpression> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            return DataResult.success((Object)new ParticleContextExpression((String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.getUnparsed()));
    private final boolean hasCustom;
    public static final ParticleContextExpression ZERO = new ParticleContextExpression("0");
    public static final ParticleContextExpression ONE = new ParticleContextExpression("1");
    public static final ParticleContextExpression PARTICLE_RAND = new ParticleContextExpression("(rand() * 2.0 - 1.0) * 0.4");

    public ParticleContextExpression(String expression) {
        this(expression, false);
    }

    public ParticleContextExpression(String expression, boolean concurrent) {
        super(expression, concurrent);
        this.hasCustom = expression.contains(CUSTOM);
    }

    @Override
    protected ParticleContextExpression createConcurrent() {
        return new ParticleContextExpression(this.getUnparsed(), true);
    }

    @Override
    protected void buildFunctions(PolytoneExpression.FunBuilder builder) {
        super.buildFunctions(builder);
    }

    @Override
    protected void buildVars(PolytoneExpression.VarBuilder builder) {
        super.buildVars(builder);
        builder.addAll(COLOR, SPEED, X, Y, Z, DX, DY, DZ, RED, GREEN, BLUE, ALPHA, SIZE, LIFE, AGE, ROLL, CUSTOM);
    }

    public double getValue(Particle particle, Level level) {
        Entity e;
        IExpression.IVars vb = this.expression.varBuilder();
        vb.setVariable(LIFE, particle.m_107273_());
        int pack = ColorUtils.pack(particle.f_107227_, particle.f_107228_, particle.f_107229_);
        vb.setVariable(COLOR, pack);
        vb.setVariable(RED, particle.f_107227_);
        vb.setVariable(GREEN, particle.f_107228_);
        vb.setVariable(BLUE, particle.f_107229_);
        vb.setVariable(SPEED, Mth.m_184648_((double)particle.f_107215_, (double)particle.f_107216_, (double)particle.f_107217_));
        vb.setVariable(ALPHA, particle.f_107230_);
        vb.setVariable(SIZE, ((SingleQuadParticle)particle).f_107663_);
        vb.setVariable(DX, particle.f_107215_);
        vb.setVariable(DY, particle.f_107216_);
        vb.setVariable(DZ, particle.f_107217_);
        vb.setVariable(X, particle.f_107212_);
        vb.setVariable(Y, particle.f_107213_);
        vb.setVariable(Z, particle.f_107214_);
        vb.setVariable(AGE, particle.f_107224_);
        vb.setVariable(ROLL, particle.f_107231_);
        if (this.hasCustom && particle instanceof CustomParticleType.Instance) {
            CustomParticleType.Instance i = (CustomParticleType.Instance)particle;
            vb.setVariable(CUSTOM, i.getCustom());
        }
        BlockPos pos = BlockPos.m_274561_((double)particle.f_107212_, (double)particle.f_107213_, (double)particle.f_107214_);
        if (this.hasPos) {
            vb.setVariable("POS_X", pos.m_123341_());
            vb.setVariable("POS_Y", pos.m_123342_());
            vb.setVariable("POS_Z", pos.m_123343_());
        }
        if (this.hasTime) {
            vb.setVariable("TIME", ClientFrameTicker.getGameTime());
        }
        if (this.hasDayTime) {
            vb.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
        }
        if (this.hasSunTime) {
            vb.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
        }
        if (this.hasRain) {
            vb.setVariable("RAIN", ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasSkyLight) {
            vb.setVariable("SKY_LIGHT", level.m_45517_(LightLayer.SKY, pos));
        }
        if (this.hasBlockLight) {
            vb.setVariable("BLOCK_LIGHT", level.m_45517_(LightLayer.BLOCK, pos));
        }
        if (this.hasTemperature) {
            vb.setVariable("TEMPERATURE", ClientFrameTicker.getTemperature());
        }
        if (this.hasDownfall) {
            vb.setVariable("DOWNFALL", ClientFrameTicker.getDownfall());
        }
        if (this.hasPlayer) {
            e = Minecraft.m_91087_().m_91288_();
            vb.setVariable("PLAYER_X", e.m_20185_());
            vb.setVariable("PLAYER_Y", e.m_20186_());
            vb.setVariable("PLAYER_Z", e.m_20189_());
        }
        if (this.hasDistance) {
            e = Minecraft.m_91087_().m_91288_();
            double x = particle.f_107212_ - e.m_20185_();
            double y = particle.f_107213_ - e.m_20186_();
            double z = particle.f_107214_ - e.m_20189_();
            vb.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
        }
        if (this.hasPlayerSpeed) {
            vb.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
        }
        if (this.hasRenderDistance) {
            vb.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
        }
        ExpressionUtils.randomizeRandom();
        return this.expression.evaluate(vb);
    }
}

