/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.polytone.particle.ParticleContextExpression;
import net.mehvahdjukaar.polytone.particle.RotationMode;
import net.mehvahdjukaar.polytone.utils.CodecUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;

public interface RotationProvider {
    public static final Codec<RotationProvider> CODEC = CodecUtil.withAlternative(CustomRotation.CODEC, RotationMode.CODEC);

    public boolean alwaysFacesCamera();

    public void applyRotation(SingleQuadParticle var1, Quaternionf var2, Camera var3, float var4);

    public record CustomRotation(ParticleContextExpression xRot, ParticleContextExpression yRot, ParticleContextExpression zRot) implements RotationProvider
    {
        public static final Codec<CustomRotation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ParticleContextExpression.CODEC.optionalFieldOf("x_rot", (Object)ParticleContextExpression.ZERO).forGetter(CustomRotation::xRot), (App)ParticleContextExpression.CODEC.optionalFieldOf("y_rot", (Object)ParticleContextExpression.ZERO).forGetter(CustomRotation::yRot), (App)ParticleContextExpression.CODEC.optionalFieldOf("z_rot", (Object)ParticleContextExpression.ZERO).forGetter(CustomRotation::zRot)).apply((Applicative)instance, CustomRotation::new));

        @Override
        public boolean alwaysFacesCamera() {
            return false;
        }

        @Override
        public void applyRotation(SingleQuadParticle particle, Quaternionf quaternionf, Camera camera, float partialTicks) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            double x = this.xRot.getValue((Particle)particle, (Level)level);
            double y = this.yRot.getValue((Particle)particle, (Level)level);
            double z = this.zRot.getValue((Particle)particle, (Level)level);
            quaternionf.rotateXYZ((float)x, (float)y, (float)z);
        }
    }
}

