/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.sound;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.mehvahdjukaar.polytone.utils.codec.CodecUtils;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;

public class PolytoneSoundType
extends SoundType {
    private static final Map<String, SoundType> SOUND_NAMES = (Map)Util.m_137537_(() -> {
        HashMap<String, SoundType> map = new HashMap<String, SoundType>();
        map.put("empty", SoundType.f_279557_);
        map.put("wood", SoundType.f_56736_);
        map.put("gravel", SoundType.f_56739_);
        map.put("grass", SoundType.f_56740_);
        map.put("lily_pad", SoundType.f_56741_);
        map.put("stone", SoundType.f_56742_);
        map.put("metal", SoundType.f_56743_);
        map.put("glass", SoundType.f_56744_);
        map.put("wool", SoundType.f_56745_);
        map.put("sand", SoundType.f_56746_);
        map.put("snow", SoundType.f_56747_);
        map.put("powder_snow", SoundType.f_154681_);
        map.put("ladder", SoundType.f_56748_);
        map.put("anvil", SoundType.f_56749_);
        map.put("slime_block", SoundType.f_56750_);
        map.put("honey_block", SoundType.f_56751_);
        map.put("wet_grass", SoundType.f_56752_);
        map.put("coral_block", SoundType.f_56753_);
        map.put("bamboo", SoundType.f_56754_);
        map.put("bamboo_sapling", SoundType.f_56755_);
        map.put("scaffolding", SoundType.f_56756_);
        map.put("sweet_berry_bush", SoundType.f_56757_);
        map.put("crop", SoundType.f_56758_);
        map.put("hard_crop", SoundType.f_56759_);
        map.put("vine", SoundType.f_56760_);
        map.put("nether_wart", SoundType.f_56761_);
        map.put("lantern", SoundType.f_56762_);
        map.put("stem", SoundType.f_56763_);
        map.put("nylium", SoundType.f_56710_);
        map.put("fungus", SoundType.f_56711_);
        map.put("roots", SoundType.f_56712_);
        map.put("shroomlight", SoundType.f_56713_);
        map.put("weeping_vines", SoundType.f_56714_);
        map.put("twisting_vines", SoundType.f_56715_);
        map.put("soul_sand", SoundType.f_56716_);
        map.put("soul_soil", SoundType.f_56717_);
        map.put("basalt", SoundType.f_56718_);
        map.put("wart_block", SoundType.f_56719_);
        map.put("netherrack", SoundType.f_56720_);
        map.put("nether_bricks", SoundType.f_56721_);
        map.put("nether_sprouts", SoundType.f_56722_);
        map.put("nether_ore", SoundType.f_56723_);
        map.put("bone_block", SoundType.f_56724_);
        map.put("netherite_block", SoundType.f_56725_);
        map.put("ancient_debris", SoundType.f_56726_);
        map.put("lodestone", SoundType.f_56727_);
        map.put("chain", SoundType.f_56728_);
        map.put("nether_gold_ore", SoundType.f_56729_);
        map.put("gilded_blackstone", SoundType.f_56730_);
        map.put("candle", SoundType.f_154653_);
        map.put("amethyst", SoundType.f_154654_);
        map.put("amethyst_cluster", SoundType.f_154655_);
        map.put("small_amethyst_bud", SoundType.f_154656_);
        map.put("medium_amethyst_bud", SoundType.f_154657_);
        map.put("large_amethyst_bud", SoundType.f_154658_);
        map.put("tuff", SoundType.f_154659_);
        map.put("calcite", SoundType.f_154660_);
        map.put("dripstone_block", SoundType.f_154661_);
        map.put("pointed_dripstone", SoundType.f_154662_);
        map.put("copper", SoundType.f_154663_);
        map.put("cave_vines", SoundType.f_154664_);
        map.put("spore_blossom", SoundType.f_154665_);
        map.put("azalea", SoundType.f_154666_);
        map.put("flowering_azalea", SoundType.f_154667_);
        map.put("moss_carpet", SoundType.f_154668_);
        map.put("pink_petals", SoundType.f_271137_);
        map.put("moss", SoundType.f_154669_);
        map.put("big_dripleaf", SoundType.f_154670_);
        map.put("small_dripleaf", SoundType.f_154671_);
        map.put("rooted_dirt", SoundType.f_154672_);
        map.put("hanging_roots", SoundType.f_154673_);
        map.put("azalea_leaves", SoundType.f_154674_);
        map.put("sculk_sensor", SoundType.f_154675_);
        map.put("sculk_catalyst", SoundType.f_222472_);
        map.put("sculk", SoundType.f_222473_);
        map.put("sculk_vein", SoundType.f_222474_);
        map.put("sculk_shrieker", SoundType.f_222475_);
        map.put("glow_lichen", SoundType.f_154676_);
        map.put("deepslate", SoundType.f_154677_);
        map.put("deepslate_bricks", SoundType.f_154678_);
        map.put("deepslate_tiles", SoundType.f_154679_);
        map.put("polished_deepslate", SoundType.f_154680_);
        map.put("froglight", SoundType.f_222465_);
        map.put("frogspawn", SoundType.f_222466_);
        map.put("muddy_mangrove_roots", SoundType.f_222468_);
        map.put("mangrove_roots ", SoundType.f_222467_);
        map.put("mud", SoundType.f_222469_);
        map.put("mud_bricks", SoundType.f_222470_);
        map.put("packed_mud", SoundType.f_222471_);
        map.put("hanging_sign", SoundType.f_244174_);
        map.put("nether_wood_hanging_sign", SoundType.f_256908_);
        map.put("bamboo_wood_hanging_sign", SoundType.f_256995_);
        map.put("bamboo_wood", SoundType.f_243772_);
        map.put("nether_wood", SoundType.f_244244_);
        map.put("cherry_wood", SoundType.f_271497_);
        map.put("cherry_sapling", SoundType.f_271370_);
        map.put("cherry_leaves", SoundType.f_271239_);
        map.put("cherry_wood_hanging_sign", SoundType.f_271094_);
        map.put("chiseled_bookshelf", SoundType.f_256956_);
        map.put("suspicious_sand", SoundType.f_271168_);
        map.put("suspicious_gravel", SoundType.f_276658_);
        map.put("decorated_pot", SoundType.f_271215_);
        map.put("decorated_pot_cracked", SoundType.f_276571_);
        map.put("trial_spawner", SoundType.f_276571_);
        return map;
    });
    public static final Codec<SoundType> REFERENCE_OR_COPY_CODEC = Codec.STRING.flatXmap(s -> {
        SoundType custom;
        if (s.startsWith("copy(")) {
            String target = s.replace("copy(", "").replace(")", "");
            ResourceLocation r = ResourceLocation.m_135820_((String)target);
            if (r == null) {
                return DataResult.error(() -> "Invalid string for Sound Type Copy function: " + s + ". Expected 'copy([some_mod]:[some_block])'");
            }
            Optional block = BuiltInRegistries.f_256975_.m_6612_(r);
            if (block.isEmpty()) {
                return DataResult.error(() -> "No block with id '" + String.valueOf(r) + "' found", (Object)SoundType.f_279557_);
            }
            Block b = (Block)block.get();
            return DataResult.success((Object)b.m_49966_().m_60827_());
        }
        SoundType vanilla = SOUND_NAMES.get(s);
        if (vanilla != null) {
            return DataResult.success((Object)vanilla);
        }
        ResourceLocation r = ResourceLocation.m_135820_((String)s);
        if (r != null && (custom = Polytone.SOUND_TYPES.getCustomSoundType(new ResourceLocation(s))) != null) {
            return DataResult.success((Object)custom);
        }
        return DataResult.error(() -> "Could not find any custom Sound Type with id " + String.valueOf(r) + " Did you place it in 'assets/[your pack]/polytone/sound_types/' ?");
    }, t -> DataResult.error(() -> "Encoding SoundTypes not supported"));
    public static final Codec<PolytoneSoundType> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(Codec.FLOAT, "volume", Float.valueOf(1.0f)).forGetter(SoundType::m_56773_), (App)StrOpt.of(Codec.FLOAT, "pitch", Float.valueOf(1.0f)).forGetter(SoundType::m_56774_), (App)CodecUtils.forwardAwareSoundEventHolder().fieldOf("break_sound").forGetter(s -> s.breakSoundHolder), (App)CodecUtils.forwardAwareSoundEventHolder().fieldOf("step_sound").forGetter(s -> s.stepSoundHolder), (App)CodecUtils.forwardAwareSoundEventHolder().fieldOf("place_sound").forGetter(s -> s.placeSoundHolder), (App)CodecUtils.forwardAwareSoundEventHolder().fieldOf("hit_sound").forGetter(s -> s.hitSoundHolder), (App)CodecUtils.forwardAwareSoundEventHolder().fieldOf("fall_sound").forGetter(s -> s.fallSoundHolder)).apply((Applicative)instance, PolytoneSoundType::new));
    public static final Codec<SoundType> CODEC = CodecUtils.referenceOrDirect(REFERENCE_OR_COPY_CODEC, DIRECT_CODEC);
    public final Holder<SoundEvent> breakSoundHolder;
    public final Holder<SoundEvent> stepSoundHolder;
    public final Holder<SoundEvent> placeSoundHolder;
    public final Holder<SoundEvent> hitSoundHolder;
    public final Holder<SoundEvent> fallSoundHolder;

    public PolytoneSoundType(float volume, float pitch, Holder<SoundEvent> breakSound, Holder<SoundEvent> stepSound, Holder<SoundEvent> placeSound, Holder<SoundEvent> hitSound, Holder<SoundEvent> fallSound) {
        super(volume, pitch, (SoundEvent)breakSound.m_203334_(), (SoundEvent)stepSound.m_203334_(), (SoundEvent)placeSound.m_203334_(), (SoundEvent)hitSound.m_203334_(), (SoundEvent)fallSound.m_203334_());
        this.breakSoundHolder = breakSound;
        this.stepSoundHolder = stepSound;
        this.placeSoundHolder = placeSound;
        this.hitSoundHolder = hitSound;
        this.fallSoundHolder = fallSound;
    }
}

