/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.tabs;

import java.util.Set;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ItemStackHelper {
    public static boolean matchItemsLenientBytes(ItemStack stack, ItemStack other) {
        if (stack == other) {
            return true;
        }
        return stack.m_41613_() == other.m_41613_() && ItemStackHelper.sameItemSameTagLenient(stack, other);
    }

    private static boolean sameItemSameTagLenient(ItemStack stack, ItemStack other) {
        if (!stack.m_150930_(other.m_41720_())) {
            return false;
        }
        return stack.m_41619_() && other.m_41619_() || ItemStackHelper.sameTagLenientBytes(stack.m_41783_(), other.m_41783_());
    }

    public static boolean sameTagLenientBytes(CompoundTag tag1, CompoundTag tag2) {
        Set keys2;
        if (tag1 == tag2) {
            return true;
        }
        if (tag1 == null || tag2 == null) {
            return false;
        }
        Set keys1 = tag1.m_128431_();
        if (!keys1.equals(keys2 = tag2.m_128431_())) {
            return false;
        }
        for (String key : keys1) {
            Tag t2;
            Tag t1 = tag1.m_128423_(key);
            if (ItemStackHelper.sameTagLenientBytesTag(t1, t2 = tag2.m_128423_(key))) continue;
            return false;
        }
        return true;
    }

    private static boolean sameTagLenientBytesTag(Tag t1, Tag t2) {
        if (t1 == t2) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        if (ItemStackHelper.isNumericTag(t1) && ItemStackHelper.isNumericTag(t2)) {
            return ItemStackHelper.numericEqual(ItemStackHelper.getNumericValue(t1), ItemStackHelper.getNumericValue(t2));
        }
        if (t1 instanceof CompoundTag && t2 instanceof CompoundTag) {
            return ItemStackHelper.sameTagLenientBytes((CompoundTag)t1, (CompoundTag)t2);
        }
        if (t1 instanceof ListTag && t2 instanceof ListTag) {
            ListTag l1 = (ListTag)t1;
            ListTag l2 = (ListTag)t2;
            if (l1.size() != l2.size()) {
                return false;
            }
            for (int i = 0; i < l1.size(); ++i) {
                if (ItemStackHelper.sameTagLenientBytesTag(l1.get(i), l2.get(i))) continue;
                return false;
            }
            return true;
        }
        if (t1 instanceof ByteArrayTag && t2 instanceof ByteArrayTag) {
            byte[] a2;
            byte[] a1 = ((ByteArrayTag)t1).m_128227_();
            if (a1.length != (a2 = ((ByteArrayTag)t2).m_128227_()).length) {
                return false;
            }
            for (int i = 0; i < a1.length; ++i) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        if (t1 instanceof IntArrayTag && t2 instanceof IntArrayTag) {
            int[] a2;
            int[] a1 = ((IntArrayTag)t1).m_128648_();
            if (a1.length != (a2 = ((IntArrayTag)t2).m_128648_()).length) {
                return false;
            }
            for (int i = 0; i < a1.length; ++i) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        if (t1 instanceof LongArrayTag && t2 instanceof LongArrayTag) {
            long[] a2;
            long[] a1 = ((LongArrayTag)t1).m_128851_();
            if (a1.length != (a2 = ((LongArrayTag)t2).m_128851_()).length) {
                return false;
            }
            for (int i = 0; i < a1.length; ++i) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        if (t1 instanceof StringTag && t2 instanceof StringTag) {
            return ((StringTag)t1).m_7916_().equals(((StringTag)t2).m_7916_());
        }
        return t1.equals((Object)t2);
    }

    private static boolean isNumericTag(Tag t) {
        return t instanceof ByteTag || t instanceof ShortTag || t instanceof IntTag || t instanceof LongTag || t instanceof FloatTag || t instanceof DoubleTag;
    }

    private static Number getNumericValue(Tag t) {
        if (t instanceof ByteTag) {
            return ((ByteTag)t).m_7063_();
        }
        if (t instanceof ShortTag) {
            return ((ShortTag)t).m_7053_();
        }
        if (t instanceof IntTag) {
            return ((IntTag)t).m_7047_();
        }
        if (t instanceof LongTag) {
            return ((LongTag)t).m_7046_();
        }
        if (t instanceof FloatTag) {
            return Float.valueOf(((FloatTag)t).m_7057_());
        }
        if (t instanceof DoubleTag) {
            return ((DoubleTag)t).m_7061_();
        }
        throw new IllegalArgumentException("Not a numeric tag: " + String.valueOf(t));
    }

    private static boolean numericEqual(Number n1, Number n2) {
        boolean n1Integral = ItemStackHelper.isIntegralNumber(n1);
        boolean n2Integral = ItemStackHelper.isIntegralNumber(n2);
        if (n1Integral && n2Integral) {
            return n1.longValue() == n2.longValue();
        }
        return Double.compare(n1.doubleValue(), n2.doubleValue()) == 0;
    }

    private static boolean isIntegralNumber(Number n) {
        return n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof Long;
    }
}

