/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;

public class ClientFrameTicker {
    private static double time;
    private static double timeOfDay;
    private static double dayTime;
    private static float rainAndThunder;
    private static int skyLight;
    private static int blockLight;
    private static BlockPos cameraPos;
    public static Holder<Biome> cameraBiome;
    private static float temperature;
    private static float downfall;
    private static float deltaTime;
    private static double playerSpeed;
    private static DimensionType lastDImType;
    private static Screen lastScreen;
    private static float screenTime;

    public static void onRenderTick(Minecraft mc) {
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        if (level.m_6042_() != lastDImType) {
            lastDImType = level.m_6042_();
            Polytone.onDimChanged((Level)level);
        }
        float partialTicks = mc.m_91296_();
        time = (float)level.m_46467_() + partialTicks;
        dayTime = (float)level.m_6042_().f_63854_().orElse(level.m_46468_()) + partialTicks;
        timeOfDay = level.m_46942_(partialTicks);
        rainAndThunder = level.m_46722_(partialTicks) * 0.5f + level.m_46661_(partialTicks) * 0.5f;
        cameraPos = mc.f_91063_.m_109153_().m_90588_();
        cameraBiome = level.m_204166_(cameraPos);
        deltaTime = Minecraft.m_91087_().m_91297_();
        if (mc.f_91074_ != null) {
            playerSpeed = mc.f_91074_.m_20184_().m_82556_();
        }
        if (mc.f_91080_ != lastScreen) {
            lastScreen = mc.f_91080_;
            screenTime = 0.0f;
        }
    }

    public static void onTick(Level level) {
        if (cameraPos != null) {
            skyLight = level.m_45517_(LightLayer.SKY, cameraPos);
            blockLight = level.m_45517_(LightLayer.BLOCK, cameraPos);
            Holder biome = level.m_204166_(cameraPos);
            temperature = ColorUtils.getClimateSettings((Biome)((Biome)biome.m_203334_())).f_47681_;
            downfall = ColorUtils.getClimateSettings((Biome)((Biome)biome.m_203334_())).f_47683_;
        }
        screenTime += 1.0f;
    }

    public static float getRainAndThunder() {
        return rainAndThunder;
    }

    public static double getDayTime() {
        return dayTime;
    }

    public static double getGameTime() {
        return time;
    }

    public static BlockPos getCameraPos() {
        return cameraPos;
    }

    public static int getBlockLight() {
        return blockLight;
    }

    public static int getSkyLight() {
        return skyLight;
    }

    public static float getTemperature() {
        return temperature;
    }

    public static float getDownfall() {
        return downfall;
    }

    public static Holder<Biome> getCameraBiome() {
        return cameraBiome;
    }

    public static float getDeltaTime() {
        return deltaTime;
    }

    public static double getSunTime() {
        return timeOfDay;
    }

    public static double getPlayerSpeed() {
        return playerSpeed;
    }

    public static double getRenderDistance() {
        return ((Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_()).intValue();
    }

    public static float getGuiTime() {
        return screenTime;
    }

    static {
        cameraPos = BlockPos.f_121853_;
    }
}

