/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils.codec;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.polytone.utils.codec.AlternativeMapCodec;
import net.mehvahdjukaar.polytone.utils.codec.ForwardAwareByNameCodec;
import net.mehvahdjukaar.polytone.utils.codec.ForwardAwareRegistryFixedCodec;
import net.mehvahdjukaar.polytone.utils.codec.LenientCodecWithLog;
import net.mehvahdjukaar.polytone.utils.codec.LenientHolderSetCodec;
import net.mehvahdjukaar.polytone.utils.codec.LenientUnboundedMapCodec;
import net.mehvahdjukaar.polytone.utils.codec.ReferenceOrDirectCodec;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class CodecUtils {
    public static <E> Codec<HolderSet<E>> forwardAwareHomogeneousList(ResourceKey<? extends Registry<E>> registryKey) {
        return LenientHolderSetCodec.create(registryKey, new ForwardAwareRegistryFixedCodec(registryKey), false);
    }

    public static <E> Codec<E> forwardAwareByNameCodec(Registry<E> reg, E defaultValue) {
        return new ForwardAwareByNameCodec(reg.m_194605_()).xmap(a -> a.orElse(defaultValue), Optional::of);
    }

    public static <E> Codec<Optional<E>> forwardAwareByNameCodec(Registry<E> reg) {
        return new ForwardAwareByNameCodec(reg.m_194605_());
    }

    public static <E> Codec<Optional<Holder<E>>> forwardAwareHolderByNameCodec(Registry<E> reg) {
        return new ForwardAwareByNameCodec<Holder<E>>(reg.m_206110_());
    }

    public static <E> Codec<Holder<E>> forwardAwareHolderByNameCodec(Registry<E> reg, Supplier<Holder<E>> defaultValue) {
        return new ForwardAwareByNameCodec(reg.m_206110_()).xmap(a -> (Holder)a.orElseGet(defaultValue), Optional::of);
    }

    public static Codec<SoundEvent> forwardAwareSoundEvent() {
        return CodecUtils.forwardAwareByNameCodec(BuiltInRegistries.f_256894_, SoundEvents.f_271165_);
    }

    public static Codec<Holder<SoundEvent>> forwardAwareSoundEventHolder() {
        return CodecUtils.forwardAwareHolderByNameCodec(BuiltInRegistries.f_256894_, () -> BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_271165_));
    }

    public static <A, B> LenientUnboundedMapCodec<A, B> lenientUnboundedMap(Codec<A> keyCodec, Codec<B> elementCodec) {
        return new LenientUnboundedMapCodec<A, B>(keyCodec, elementCodec);
    }

    public static <A> MapCodec<A> lenientWithLog(Codec<A> elementCodec, String name, A defaultValue) {
        return LenientCodecWithLog.of(elementCodec, name, defaultValue);
    }

    public static <A> MapCodec<Optional<A>> lenientWithLog(Codec<A> elementCodec, String name) {
        return LenientCodecWithLog.of(elementCodec, name);
    }

    public static <B> MapCodec<Optional<B>> optionalAlias(Codec<B> codec, String primaryName, String alias) {
        return AlternativeMapCodec.optionalAlias(codec, primaryName, alias);
    }

    public static <B> MapCodec<B> alias(Codec<B> codec, String primaryName, String alias) {
        return AlternativeMapCodec.alias(codec, primaryName, alias);
    }

    public static <E> ReferenceOrDirectCodec<E> referenceOrDirect(Codec<? extends E> reference, Codec<? extends E> direct) {
        return new ReferenceOrDirectCodec<E>(reference, direct);
    }

    public static <E> ReferenceOrDirectCodec<E> referenceOrDirect(Codec<? extends E> reference, Codec<? extends E> direct, boolean bothStrings) {
        return new ReferenceOrDirectCodec<E>(reference, direct, bothStrings);
    }
}

