/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.forge;

import com.google.common.collect.BiMap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.serialization.Codec;
import cpw.mods.modlauncher.api.INameMappingService;
import java.lang.reflect.Field;
import java.util.BitSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.forge.AlexsCavesCompat;
import net.mehvahdjukaar.polytone.mixins.forge.BlockColorsAccessor;
import net.mehvahdjukaar.polytone.mixins.forge.CreativeTabAccessor;
import net.mehvahdjukaar.polytone.mixins.forge.ItemColorsAccessor;
import net.mehvahdjukaar.polytone.mixins.forge.ModifiableBiomeAccessor;
import net.mehvahdjukaar.polytone.mixins.forge.ModifiableBiomeInfoBiomeInfoAccessor;
import net.mehvahdjukaar.polytone.mixins.forge.ParticleEngineAccessor;
import net.mehvahdjukaar.polytone.particle.ExtraDataParticleOptions;
import net.mehvahdjukaar.polytone.tabs.CreativeTabModifier;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.DimensionSpecialEffectsManager;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Contract;
import org.joml.Vector3f;

public class PlatStuffImpl {
    private static final Field NAMES;
    private static final Field IDS;
    private static final Field AVAILABILITYMAP;
    private static final Field KEYS;
    private static final Field OWNERS;
    private static final Field HASWRAPPER;
    private static final Field OVERRIDES;
    private static Field VANILLA_TABS;
    private static final boolean AC;

    public static boolean isModStateValid() {
        return ModLoader.isLoadingStateValid();
    }

    public static void addClientReloadListener(Supplier<PreparableReloadListener> listener, ResourceLocation location) {
        Consumer<RegisterClientReloadListenersEvent> eventConsumer = event -> event.registerReloadListener((PreparableReloadListener)listener.get());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void setParticleProvider(ParticleType<?> type, ParticleProvider<?> provider) {
        ParticleEngineAccessor engine = (ParticleEngineAccessor)Minecraft.m_91087_().f_91061_;
        engine.getProviders().put(BuiltInRegistries.f_257034_.m_7981_(type), provider);
    }

    public static void unregisterParticleProvider(ResourceLocation id) {
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        ((ParticleEngineAccessor)particleEngine).getProviders().remove(id);
    }

    public static ParticleType<ExtraDataParticleOptions> makeParticleType(boolean forceSpawn) {
        final AtomicReference<1> ref = new AtomicReference<1>();
        ParticleType<ExtraDataParticleOptions> instance = new ParticleType<ExtraDataParticleOptions>(forceSpawn, ExtraDataParticleOptions.DESERIALIZER){

            public Codec<ExtraDataParticleOptions> m_7652_() {
                return ExtraDataParticleOptions.codec(ref::get);
            }
        };
        ref.set(instance);
        return instance;
    }

    public static BlockColor getBlockColor(BlockColors colors, Block block) {
        try {
            return ((BlockColorsAccessor)colors).getBlockColors().get(ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)block));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ItemColor getItemColor(ItemColors colors, Item block) {
        try {
            return ((ItemColorsAccessor)colors).getItemColors().get(ForgeRegistries.ITEMS.getDelegateOrThrow((Object)block));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends ParticleType<?>> T registerParticleType(ResourceLocation id, T sound) {
        ForgeRegistry reg = (ForgeRegistry)ForgeRegistries.PARTICLE_TYPES;
        PlatStuffImpl.registerDyn(id, sound, reg);
        return sound;
    }

    public static <T extends SoundEvent> T registerSoundEvent(ResourceLocation id, T sound) {
        ForgeRegistry reg = (ForgeRegistry)ForgeRegistries.SOUND_EVENTS;
        PlatStuffImpl.registerDyn(id, sound, reg);
        return sound;
    }

    private static <T> void registerDyn(ResourceLocation id, T sound, ForgeRegistry<T> reg) {
        boolean wasLocked = reg.isLocked();
        if (wasLocked) {
            reg.unfreeze();
        }
        reg.register(id, sound);
        if (wasLocked) {
            reg.freeze();
        }
    }

    public static void unregisterParticleType(ResourceLocation id) {
        PlatStuffImpl.unregisterDyn(id, ForgeRegistries.PARTICLE_TYPES);
    }

    public static void unregisterSoundEvent(ResourceLocation id) {
        PlatStuffImpl.unregisterDyn(id, ForgeRegistries.SOUND_EVENTS);
    }

    private static void unregisterDyn(ResourceLocation id, IForgeRegistry<?> registry) {
        try {
            PlatStuffImpl.remove((ForgeRegistry)registry, id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static <V> int remove(ForgeRegistry<V> registry, ResourceLocation key) throws Exception {
        Multimap overrides;
        Object value = ((BiMap)NAMES.get(registry)).remove((Object)key);
        if (value == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The name %s is not registered in the registry.", key));
        }
        int idToRemove = registry.getID(value);
        ((BiMap)IDS.get(registry)).remove((Object)idToRemove);
        ((BitSet)AVAILABILITYMAP.get(registry)).clear(idToRemove);
        ResourceKey rkey = ResourceKey.m_135785_((ResourceKey)registry.getRegistryKey(), (ResourceLocation)key);
        ((BiMap)KEYS.get(registry)).remove((Object)rkey);
        ((BiMap)OWNERS.get(registry)).inverse().remove(value);
        if (((Boolean)HASWRAPPER.get(registry)).booleanValue() && (overrides = (Multimap)OVERRIDES.get(registry)).containsKey((Object)key)) {
            overrides.get((Object)key).add(value);
            if (overrides.get((Object)key).isEmpty()) {
                overrides.remove((Object)key, value);
            }
        }
        return idToRemove;
    }

    public static String maybeRemapName(String s) {
        return ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.CLASS, (String)s);
    }

    @Contract
    public static boolean isModLoaded(String namespace) {
        return ModList.get().isLoaded(namespace);
    }

    public static DimensionSpecialEffects getDimensionEffects(ResourceLocation id) {
        return DimensionSpecialEffectsManager.getForType((ResourceLocation)id);
    }

    public static void applyBiomeSurgery(Biome biome, BiomeSpecialEffects newEffects) {
        ModifiableBiomeInfo modifiable = biome.modifiableBiomeInfo();
        ModifiableBiomeInfo.BiomeInfo modifiedInfo = modifiable.getModifiedBiomeInfo();
        if (modifiedInfo == null) {
            modifiedInfo = ModifiableBiomeInfo.BiomeInfo.Builder.copyOf((ModifiableBiomeInfo.BiomeInfo)modifiable.getOriginalBiomeInfo()).build();
            ((ModifiableBiomeAccessor)modifiable).setModifiedBiomeInfo(modifiedInfo);
        }
        ((ModifiableBiomeInfoBiomeInfoAccessor)modifiedInfo).setEffects(newEffects);
    }

    public static void addTabEventForTab(ResourceKey<CreativeModeTab> key) {
    }

    public static void sortTabs() {
        if (VANILLA_TABS == null) {
            VANILLA_TABS = ObfuscationReflectionHelper.findField(CreativeModeTabRegistry.class, (String)"DEFAULT_TABS");
        }
        try {
            ((List)VANILLA_TABS.get(null)).clear();
            CreativeModeTabRegistry.sortTabs();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static RegistryAccess hackyGetRegistryAccess() {
        ClientLevel level;
        if (FMLEnvironment.dist == Dist.CLIENT && RenderSystem.isOnRenderThread() && (level = Minecraft.m_91087_().f_91073_) != null) {
            return level.m_9598_();
        }
        return null;
    }

    public static CreativeModeTab createCreativeTab(ResourceLocation id) {
        return CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)id.toString())).m_257652_();
    }

    public static CreativeTabModifier modifyTab(CreativeTabModifier mod, CreativeModeTab tab) {
        CreativeTabAccessor acc = (CreativeTabAccessor)tab;
        Component oldName = null;
        if (mod.name().isPresent()) {
            oldName = tab.m_40786_();
            acc.setDisplayName(mod.name().get());
        }
        ItemStack oldIcon = null;
        if (mod.icon().isPresent()) {
            oldIcon = tab.m_40787_();
            acc.setIcon(mod.icon().get());
        }
        Boolean oldSearch = null;
        Integer oldSearchWidth = null;
        if (mod.search().isPresent()) {
            oldSearch = tab.hasSearchBar();
            acc.setHasSearchBar(mod.search().get());
        }
        if (mod.searchWidth().isPresent()) {
            oldSearchWidth = tab.getSearchBarWidth();
            acc.setSearchBarWidth(mod.searchWidth().get());
        }
        Boolean oldCanScroll = null;
        if (mod.canScroll().isPresent()) {
            oldCanScroll = tab.m_40791_();
            acc.setCanScroll(mod.canScroll().get());
        }
        Boolean oldShowTitle = null;
        if (mod.showTitle().isPresent()) {
            oldShowTitle = tab.m_40789_();
            acc.setShowTitle(mod.showTitle().get());
        }
        ResourceLocation oldTabsImage = null;
        if (mod.tabsImage().isPresent()) {
            oldTabsImage = tab.getTabsImage();
            acc.setTabsImage(mod.tabsImage().get());
        }
        ResourceLocation oldBackgroundLocation = null;
        if (mod.backGroundLocation().isPresent()) {
            oldBackgroundLocation = tab.getBackgroundLocation();
            acc.setBackgroundLocation(mod.backGroundLocation().get());
        }
        List oldBeforeTabs = null;
        if (mod.beforeTabs().isPresent()) {
            oldBeforeTabs = tab.tabsBefore;
            acc.setBeforeTabs(mod.beforeTabs().get());
        }
        List oldAfterTabs = null;
        if (mod.afterTabs().isPresent()) {
            oldAfterTabs = tab.tabsAfter;
            acc.setAfterTabs(mod.afterTabs().get());
        }
        return new CreativeTabModifier(Optional.ofNullable(oldIcon), Optional.ofNullable(oldSearch), Optional.ofNullable(oldSearchWidth), Optional.ofNullable(oldCanScroll), Optional.ofNullable(oldShowTitle), Optional.ofNullable(oldName), Optional.ofNullable(oldBackgroundLocation), Optional.ofNullable(oldTabsImage), Optional.ofNullable(oldBeforeTabs), Optional.ofNullable(oldAfterTabs), List.of(), List.of(), Targets.EMPTY);
    }

    public static String getVersion() {
        return ((ModContainer)ModList.get().getModContainerById("polytone").get()).getModInfo().getVersion().toString();
    }

    public static RenderType getRenderType(Block block) {
        return null;
    }

    public static void setRenderType(Block block, RenderType renderType) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderType);
    }

    public static void adjustLightmapColors(ClientLevel level, float partialTicks, float skyDarken, float skyLight, float flicker, int torchX, int skyY, Vector3f combined) {
        if (AC) {
            AlexsCavesCompat.applyACLightingColors(level, combined);
        }
        level.m_104583_().adjustLightmapColors(level, partialTicks, skyDarken, skyLight, flicker, torchX, skyY, combined);
    }

    public static float compatACModifyGamma(float partialTicks, float gamma) {
        return AC ? AlexsCavesCompat.modifyGamma(partialTicks, gamma) : gamma;
    }

    public static ParticleProvider<?> getParticleProvider(ParticleType<?> type) {
        return ((ParticleEngineAccessor)Minecraft.m_91087_().f_91061_).getProviders().get(BuiltInRegistries.f_257034_.m_7981_(type));
    }

    public static RegistryAccess getServerRegistryAccess() {
        return ServerLifecycleHooks.getCurrentServer().m_206579_();
    }

    public static void addSpecialModelRegistration(Consumer<PlatStuff.SpecialModelEvent> eventListener) {
        Consumer<ModelEvent.RegisterAdditional> eventConsumer = event -> eventListener.accept(new PlatStuff.SpecialModelEvent((ModelEvent.RegisterAdditional)event){
            final /* synthetic */ ModelEvent.RegisterAdditional val$event;
            {
                this.val$event = registerAdditional;
            }

            @Override
            public void register(ModelResourceLocation modelLocation) {
                this.val$event.register((ResourceLocation)modelLocation);
            }

            @Override
            public void register(ResourceLocation id) {
                this.val$event.register(id);
            }
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static BakedModel getModel(ResourceLocation modelLocation) {
        return Minecraft.m_91087_().m_91304_().getModel(modelLocation);
    }

    public static void registerShaders(ResourceLocation id, VertexFormat format, Consumer<ShaderInstance> shaderConsumer) {
        Consumer<RegisterShadersEvent> eventConsumer = event -> {
            try {
                ShaderInstance shader = new ShaderInstance(event.getResourceProvider(), id, format);
                event.registerShader(shader, shaderConsumer);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to parse shader: " + String.valueOf(id), e);
            }
        };
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void doAddModels() {
    }

    static {
        try {
            NAMES = ForgeRegistry.class.getDeclaredField("names");
            IDS = ForgeRegistry.class.getDeclaredField("ids");
            AVAILABILITYMAP = ForgeRegistry.class.getDeclaredField("availabilityMap");
            KEYS = ForgeRegistry.class.getDeclaredField("keys");
            OWNERS = ForgeRegistry.class.getDeclaredField("owners");
            HASWRAPPER = ForgeRegistry.class.getDeclaredField("hasWrapper");
            OVERRIDES = ForgeRegistry.class.getDeclaredField("overrides");
            NAMES.setAccessible(true);
            IDS.setAccessible(true);
            AVAILABILITYMAP.setAccessible(true);
            KEYS.setAccessible(true);
            OWNERS.setAccessible(true);
            HASWRAPPER.setAccessible(true);
            OVERRIDES.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        VANILLA_TABS = null;
        AC = ModList.get().isLoaded("alexscaves");
    }
}

