/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockClientTickable;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.particle.CustomParticleType;
import net.mehvahdjukaar.polytone.particle.ExtraDataParticleOptions;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.mehvahdjukaar.polytone.utils.codec.BiggerCodecs;
import net.mehvahdjukaar.polytone.utils.codec.CodecUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record BlockParticleEmitter(Optional<Holder<ParticleType<?>>> particleType, BlockContextExpression chance, BlockContextExpression count, BlockContextExpression x, BlockContextExpression y, BlockContextExpression z, BlockContextExpression dx, BlockContextExpression dy, BlockContextExpression dz, Optional<BlockContextExpression> r, Optional<BlockContextExpression> g, Optional<BlockContextExpression> b, Optional<BlockContextExpression> a, Optional<BlockContextExpression> roll, Optional<BlockContextExpression> size, Optional<BlockContextExpression> custom, RuleTest predicate, Optional<HolderSet<Biome>> biomes, SpawnLocation spawnLocation) implements BlockClientTickable
{
    public static final Codec<BlockParticleEmitter> CODEC = RecordCodecBuilder.create(i -> BiggerCodecs.group(i, CodecUtils.forwardAwareHolderByNameCodec(BuiltInRegistries.f_257034_).fieldOf("particle").forGetter(BlockParticleEmitter::particleType), StrOpt.of(BlockContextExpression.CODEC, "chance", BlockContextExpression.ONE).forGetter(BlockParticleEmitter::chance), StrOpt.of(BlockContextExpression.CODEC, "count", BlockContextExpression.ONE).forGetter(BlockParticleEmitter::count), StrOpt.of(BlockContextExpression.CODEC, "x", BlockContextExpression.PARTICLE_RAND).forGetter(BlockParticleEmitter::x), StrOpt.of(BlockContextExpression.CODEC, "y", BlockContextExpression.PARTICLE_RAND).forGetter(BlockParticleEmitter::y), StrOpt.of(BlockContextExpression.CODEC, "z", BlockContextExpression.PARTICLE_RAND).forGetter(BlockParticleEmitter::z), StrOpt.of(BlockContextExpression.CODEC, "dx", BlockContextExpression.ZERO).forGetter(BlockParticleEmitter::dx), StrOpt.of(BlockContextExpression.CODEC, "dy", BlockContextExpression.ZERO).forGetter(BlockParticleEmitter::dy), StrOpt.of(BlockContextExpression.CODEC, "dz", BlockContextExpression.ZERO).forGetter(BlockParticleEmitter::dz), BlockContextExpression.CODEC.optionalFieldOf("red").forGetter(BlockParticleEmitter::r), BlockContextExpression.CODEC.optionalFieldOf("green").forGetter(BlockParticleEmitter::g), BlockContextExpression.CODEC.optionalFieldOf("blue").forGetter(BlockParticleEmitter::b), BlockContextExpression.CODEC.optionalFieldOf("alpha").forGetter(BlockParticleEmitter::a), BlockContextExpression.CODEC.optionalFieldOf("roll").forGetter(BlockParticleEmitter::roll), BlockContextExpression.CODEC.optionalFieldOf("size").forGetter(BlockParticleEmitter::size), BlockContextExpression.CODEC.optionalFieldOf("custom").forGetter(BlockParticleEmitter::custom), CodecUtils.lenientWithLog(RuleTest.f_74307_, "state_predicate", AlwaysTrueTest.f_73954_).forGetter(BlockParticleEmitter::predicate), CodecUtils.forwardAwareHomogeneousList(Registries.f_256952_).optionalFieldOf("biomes").forGetter(BlockParticleEmitter::biomes), StrOpt.of(SpawnLocation.CODEC, "spawn_location", SpawnLocation.CENTER).forGetter(BlockParticleEmitter::spawnLocation)).apply(i, BlockParticleEmitter::new));

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.particleType.isEmpty()) {
            return;
        }
        double spawnChance = this.chance.getValue(level, pos, state);
        if ((double)level.f_46441_.m_188501_() < spawnChance && this.predicate().m_213865_(state, level.f_46441_)) {
            if (this.biomes.isPresent()) {
                Holder biome = level.m_204166_(pos);
                if (!this.biomes.get().m_203333_(biome)) {
                    return;
                }
            }
            int i = 0;
            while ((double)i < this.count.getValue(level, pos, state)) {
                CustomParticleType.setStateHack(state);
                ParticleOptions po = this.getParticleOptions(level, pos, state);
                if (po == null) {
                    return;
                }
                Vec3 pp = this.spawnLocation.getLocation(pos, state, level.f_46441_);
                level.m_7106_(po, pp.m_7096_() + this.x.getValue(level, pos, state), pp.m_7098_() + this.y.getValue(level, pos, state), pp.m_7094_() + this.z.getValue(level, pos, state), this.dx.getValue(level, pos, state), this.dy.getValue(level, pos, state), this.dz.getValue(level, pos, state));
                ++i;
            }
        }
    }

    @Nullable
    private ParticleOptions getParticleOptions(Level level, BlockPos pos, BlockState state) {
        SimpleParticleType po;
        ParticleType particleTypeValue = (ParticleType)this.particleType.get().m_203334_();
        if (Polytone.CUSTOM_PARTICLES.isDynamicParticle(((ResourceKey)this.particleType.get().m_203543_().get()).m_135782_())) {
            HashMap<String, Float> map = new HashMap<String, Float>();
            this.r.ifPresent(exp -> map.put("red", Float.valueOf((float)exp.getValue(level, pos, state))));
            this.g.ifPresent(exp -> map.put("green", Float.valueOf((float)exp.getValue(level, pos, state))));
            this.b.ifPresent(exp -> map.put("blue", Float.valueOf((float)exp.getValue(level, pos, state))));
            this.a.ifPresent(exp -> map.put("alpha", Float.valueOf((float)exp.getValue(level, pos, state))));
            this.roll.ifPresent(exp -> map.put("roll", Float.valueOf((float)exp.getValue(level, pos, state))));
            this.size.ifPresent(exp -> map.put("size", Float.valueOf((float)exp.getValue(level, pos, state))));
            this.custom.ifPresent(exp -> map.put("custom", Float.valueOf((float)exp.getValue(level, pos, state))));
            return new ExtraDataParticleOptions(map, particleTypeValue);
        }
        if (particleTypeValue instanceof SimpleParticleType) {
            SimpleParticleType st;
            po = st = (SimpleParticleType)particleTypeValue;
        } else if (particleTypeValue == ParticleTypes.f_123794_ || particleTypeValue == ParticleTypes.f_123814_ || particleTypeValue == ParticleTypes.f_194652_ || particleTypeValue == ParticleTypes.f_123805_) {
            po = new BlockParticleOption(particleTypeValue, state);
        } else if (particleTypeValue == ParticleTypes.f_123752_) {
            po = new ItemParticleOption(particleTypeValue, state.m_60734_().m_5456_().m_7968_());
        } else {
            Polytone.LOGGER.error("Unsupported particle type: {}", (Object)particleTypeValue);
            return null;
        }
        return po;
    }

    public static Vec3 getParticleSpawnPosOnFace(RandomSource random, BlockPos pos, Direction direction) {
        Vec3 vec3 = Vec3.m_82512_((Vec3i)pos);
        int i = direction.m_122429_();
        int j = direction.m_122430_();
        int k = direction.m_122431_();
        double d0 = vec3.f_82479_ + (i == 0 ? Mth.m_216263_((RandomSource)random, (double)-0.5, (double)0.5) : (double)i * 0.6);
        double d1 = vec3.f_82480_ + (j == 0 ? Mth.m_216263_((RandomSource)random, (double)-0.5, (double)0.5) : (double)j * 0.6);
        double d2 = vec3.f_82481_ + (k == 0 ? Mth.m_216263_((RandomSource)random, (double)-0.5, (double)0.5) : (double)k * 0.6);
        return new Vec3(d0, d1, d2);
    }

    public static enum SpawnLocation {
        CENTER,
        LOWER_CORNER,
        BLOCK_FACES;

        public static final Codec<SpawnLocation> CODEC;

        Vec3 getLocation(BlockPos pos, BlockState state, RandomSource rand) {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 1 -> Vec3.m_82528_((Vec3i)pos);
                case 0 -> Vec3.m_82512_((Vec3i)pos);
                case 2 -> {
                    Direction dir = Direction.values()[rand.m_188503_(Direction.values().length)];
                    yield BlockParticleEmitter.getParticleSpawnPosOnFace(rand, pos, dir);
                }
            };
        }

        static {
            CODEC = Codec.STRING.xmap(s -> SpawnLocation.valueOf(s.toUpperCase(Locale.ROOT)), e -> e.name().toLowerCase(Locale.ROOT));
        }
    }
}

