/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.mehvahdjukaar.polytone.utils.exp.IExpression;
import net.mehvahdjukaar.polytone.utils.exp.PolytoneExpression;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class BlockContextExpression
extends PolytoneExpression {
    public static final Codec<BlockContextExpression> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            return DataResult.success((Object)new BlockContextExpression((String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.getUnparsed()));
    private final boolean hasState;
    public static final BlockContextExpression ZERO = new BlockContextExpression("0");
    public static final BlockContextExpression ONE = new BlockContextExpression("1");
    public static final BlockContextExpression PARTICLE_RAND = new BlockContextExpression("(rand() * 2.0 - 1.0) * 0.4");

    public BlockContextExpression(String unparsed) {
        this(unparsed, false);
    }

    public BlockContextExpression(String unparsed, boolean concurrent) {
        super(unparsed, concurrent);
        this.hasState = unparsed.contains("state_prop");
    }

    @Override
    protected BlockContextExpression createConcurrent() {
        return new BlockContextExpression(this.getUnparsed(), true);
    }

    @Override
    protected void buildFunctions(PolytoneExpression.FunBuilder builder) {
        super.buildFunctions(builder);
        builder.add(STATE_PROP);
        builder.add(STATE_PROP_INT);
    }

    public double getValue(class_243 pos, float entityTime, class_1937 level) {
        class_1297 e;
        ExpressionUtils.randomizeRandom();
        IExpression.IVars vb = this.expression.varBuilder();
        if (this.hasPos) {
            vb.setVariable("POS_X", pos.field_1352);
            vb.setVariable("POS_Y", pos.field_1351);
            vb.setVariable("POS_Z", pos.field_1350);
        }
        class_2338 p = class_2338.method_49638((class_2374)pos);
        if (this.hasTime) {
            vb.setVariable("TIME", entityTime);
        }
        if (this.hasDayTime) {
            vb.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
        }
        if (this.hasSunTime) {
            vb.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
        }
        if (this.hasRain) {
            vb.setVariable("RAIN", ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasSeason) {
            vb.setVariable("SEASON", ClientFrameTicker.getSeason());
        }
        if (this.hasSkyLight) {
            vb.setVariable("SKY_LIGHT", level.method_8314(class_1944.field_9284, p));
        }
        if (this.hasBlockLight) {
            vb.setVariable("BLOCK_LIGHT", level.method_8314(class_1944.field_9282, p));
        }
        if (this.hasTemperature) {
            vb.setVariable("TEMPERATURE", ColorUtils.getClimateSettings((class_1959)((class_1959)level.method_23753((class_2338)p).comp_349())).comp_844);
        }
        if (this.hasDownfall) {
            vb.setVariable("DOWNFALL", ColorUtils.getClimateSettings((class_1959)((class_1959)level.method_23753((class_2338)p).comp_349())).comp_846);
        }
        if (this.hasState) {
            STATE_HACK.set(level.method_8320(p));
        }
        if (this.hasPlayer) {
            e = class_310.method_1551().method_1560();
            vb.setVariable("PLAYER_X", e.method_23317());
            vb.setVariable("PLAYER_Y", e.method_23318());
            vb.setVariable("PLAYER_Z", e.method_23321());
        }
        if (this.hasDistance) {
            e = class_310.method_1551().method_1560();
            double x = pos.field_1352 - e.method_23317();
            double y = pos.field_1351 - e.method_23318();
            double z = pos.field_1350 - e.method_23321();
            vb.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
        }
        if (this.hasPlayerSpeed) {
            vb.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
        }
        if (this.hasRenderDistance) {
            vb.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
        }
        return this.expression.evaluate(vb);
    }

    public double getValue(class_1937 level, @NotNull class_2338 pos, class_2680 state) {
        class_1297 e;
        ExpressionUtils.seedRandom(state.method_26190(pos));
        IExpression.IVars vars = this.expression.varBuilder();
        if (this.hasPos) {
            vars.setVariable("POS_X", pos.method_10263());
            vars.setVariable("POS_Y", pos.method_10264());
            vars.setVariable("POS_Z", pos.method_10260());
        }
        if (this.hasTime) {
            vars.setVariable("TIME", ClientFrameTicker.getGameTime());
        }
        if (this.hasDayTime) {
            vars.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
        }
        if (this.hasSunTime) {
            vars.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
        }
        if (this.hasRain) {
            vars.setVariable("RAIN", ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasSeason) {
            vars.setVariable("SEASON", ClientFrameTicker.getSeason());
        }
        if (this.hasSkyLight) {
            vars.setVariable("SKY_LIGHT", level.method_8314(class_1944.field_9284, pos));
        }
        if (this.hasBlockLight) {
            vars.setVariable("BLOCK_LIGHT", level.method_8314(class_1944.field_9282, pos));
        }
        if (this.hasTemperature) {
            vars.setVariable("TEMPERATURE", ColorUtils.getClimateSettings((class_1959)((class_1959)level.method_23753((class_2338)pos).comp_349())).comp_844);
        }
        if (this.hasDownfall) {
            vars.setVariable("DOWNFALL", ColorUtils.getClimateSettings((class_1959)((class_1959)level.method_23753((class_2338)pos).comp_349())).comp_846);
        }
        if (this.hasState) {
            STATE_HACK.set(state);
        }
        if (this.hasPlayer) {
            e = class_310.method_1551().method_1560();
            vars.setVariable("PLAYER_X", e.method_23317());
            vars.setVariable("PLAYER_Y", e.method_23318());
            vars.setVariable("PLAYER_Z", e.method_23321());
        }
        if (this.hasDistance) {
            e = class_310.method_1551().method_1560();
            double x = (double)pos.method_10263() - e.method_23317();
            double y = (double)pos.method_10264() - e.method_23318();
            double z = (double)pos.method_10260() - e.method_23321();
            vars.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
        }
        if (this.hasPlayerSpeed) {
            vars.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
        }
        if (this.hasRenderDistance) {
            vars.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
        }
        return this.expression.evaluate(vars);
    }
}

