/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.colormap.IColormapNumberProvider;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.mehvahdjukaar.polytone.utils.exp.IExpression;
import net.mehvahdjukaar.polytone.utils.exp.PolytoneExpression;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class ColormapExpressionProvider
extends PolytoneExpression
implements IColormapNumberProvider {
    protected static final String BIOME_VALUE = "BIOME_VALUE";
    protected static final String DAMAGE = "DAMAGE";
    public static final Codec<ColormapExpressionProvider> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            return DataResult.success((Object)new ColormapExpressionProvider((String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.getUnparsed()));
    protected final boolean usesBiome;
    protected final boolean hasState;

    protected ColormapExpressionProvider(String unparsed) {
        this(unparsed, false);
    }

    protected ColormapExpressionProvider(String unparsed, boolean concurrent) {
        super(unparsed, concurrent);
        this.usesBiome = unparsed.contains("TEMPERATURE") || unparsed.contains("DOWNFALL") || unparsed.contains(BIOME_VALUE);
        this.hasState = unparsed.contains("state_prop");
    }

    @Override
    public ColormapExpressionProvider createConcurrent() {
        return new ColormapExpressionProvider(this.getUnparsed(), true);
    }

    @Override
    protected void buildVars(PolytoneExpression.VarBuilder builder) {
        super.buildVars(builder);
        builder.addAll(BIOME_VALUE, DAMAGE);
    }

    @Override
    protected void buildFunctions(PolytoneExpression.FunBuilder builder) {
        super.buildFunctions(builder);
        builder.addAll(STATE_PROP_INT, STATE_PROP);
    }

    @Override
    public boolean usesBiome() {
        return this.usesBiome;
    }

    @Override
    public boolean usesPos() {
        return this.hasPos;
    }

    @Override
    public boolean usesState() {
        return this.hasState;
    }

    @Override
    public float getValue(@Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
        class_1297 e;
        if (pos == null) {
            pos = class_2338.field_10980;
            ExpressionUtils.randomizeRandom();
        } else {
            ExpressionUtils.seedRandom((long)pos.hashCode() * pos.method_10063());
        }
        IExpression.IVars vb = this.expression.varBuilder();
        if (this.hasPos) {
            vb.setVariable("POS_X", pos.method_10263());
            vb.setVariable("POS_Y", pos.method_10264());
            vb.setVariable("POS_Z", pos.method_10260());
        }
        if (this.hasTime) {
            vb.setVariable("TIME", ClientFrameTicker.getGameTime());
        }
        if (this.hasDayTime) {
            vb.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
        }
        if (this.hasSunTime) {
            vb.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
        }
        if (this.hasRain) {
            vb.setVariable("RAIN", ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasSeason) {
            vb.setVariable("SEASON", ClientFrameTicker.getSeason());
        }
        if (this.hasSkyLight) {
            vb.setVariable("SKY_LIGHT", class_310.method_1551().field_1687.method_8314(class_1944.field_9284, pos));
        }
        if (this.hasBlockLight) {
            vb.setVariable("BLOCK_LIGHT", class_310.method_1551().field_1687.method_8314(class_1944.field_9282, pos));
        }
        if (this.hasTemperature) {
            vb.setVariable("TEMPERATURE", biome != null ? (double)ColorUtils.getClimateSettings((class_1959)biome).comp_844 : 0.0);
        }
        if (this.hasDownfall) {
            vb.setVariable("DOWNFALL", biome != null ? (double)ColorUtils.getClimateSettings((class_1959)biome).comp_846 : 0.0);
        }
        if (this.hasPlayer) {
            e = class_310.method_1551().method_1560();
            vb.setVariable("PLAYER_X", e.method_23317());
            vb.setVariable("PLAYER_Y", e.method_23318());
            vb.setVariable("PLAYER_Z", e.method_23321());
        }
        if (this.hasDistance) {
            e = class_310.method_1551().method_1560();
            double x = (double)pos.method_10263() - e.method_23317();
            double y = (double)pos.method_10264() - e.method_23318();
            double z = (double)pos.method_10260() - e.method_23321();
            vb.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
        }
        if (this.hasPlayerSpeed) {
            vb.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
        }
        if (this.hasRenderDistance) {
            vb.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
        }
        if (stack != null) {
            float damage = 1.0f - (float)stack.method_7919() / (float)stack.method_7936();
            vb.setVariable(DAMAGE, damage);
        } else {
            vb.setVariable(DAMAGE, 0.0);
        }
        if (this.hasState) {
            STATE_HACK.set(state);
        }
        float result = (float)this.expression.evaluate(vb);
        STATE_HACK.remove();
        return result;
    }
}

