/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.serialization.Codec;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.colormap.ColormapExpressionProvider;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.mehvahdjukaar.polytone.utils.codec.CodecUtils;
import net.minecraft.class_1799;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IColormapNumberProvider {
    public static final MapRegistry<IColormapNumberProvider> BUILTIN_PROVIDERS = new MapRegistry("Colormap Number Providers");
    public static final Codec<IColormapNumberProvider> CODEC = CodecUtils.referenceOrDirect(BUILTIN_PROVIDERS, ColormapExpressionProvider.CODEC, true);
    public static final IColormapNumberProvider ZERO = BUILTIN_PROVIDERS.register("zero", new Const(0.0f));
    public static final IColormapNumberProvider ONE = BUILTIN_PROVIDERS.register("one", new Const(1.0f));
    public static final IColormapNumberProvider DAY_TIME = BUILTIN_PROVIDERS.register("day_time", (state, pos, biome, mapper, stack) -> (float)(1.0 - ClientFrameTicker.getDayTime() % 24000.0 / 24000.0));
    public static final IColormapNumberProvider TEMPERATURE = BUILTIN_PROVIDERS.register("temperature", new IColormapNumberProvider(){

        @Override
        public float getValue(class_2680 state, @NotNull class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
            return biome == null ? 0.0f : ColorUtils.getClimateSettings((class_1959)biome).comp_844;
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapNumberProvider LEGACY_TEMPERATURE = BUILTIN_PROVIDERS.register("legacy_temperature", new IColormapNumberProvider(){

        @Override
        public float getValue(class_2680 state, @NotNull class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
            return biome == null ? 0.0f : biome.method_21740(pos);
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapNumberProvider DOWNFALL = BUILTIN_PROVIDERS.register("downfall", new IColormapNumberProvider(){

        @Override
        public float getValue(class_2680 state, @NotNull class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
            return biome == null ? 0.0f : ColorUtils.getClimateSettings((class_1959)biome).comp_846;
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapNumberProvider BIOME_ID = BUILTIN_PROVIDERS.register("biome_id", new IColormapNumberProvider(){

        @Override
        public float getValue(@Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
            if (biome == null) {
                return 0.0f;
            }
            return 1.0f - mapper.getIndex(biome);
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapNumberProvider Y_LEVEL = BUILTIN_PROVIDERS.register("y_level", new IColormapNumberProvider(){

        @Override
        public float getValue(@Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
            if (pos == null) {
                return 64.0f;
            }
            class_5819 rs = class_5819.method_43049((long)((long)pos.hashCode() * pos.method_10063()));
            float yVariance = 4.0f;
            float v = yVariance * (rs.method_43057() - 0.5f);
            return 1.0f - ((float)(pos.method_10264() + 64) + v) / 256.0f;
        }

        @Override
        public boolean usesBiome() {
            return false;
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapNumberProvider DAMAGE = BUILTIN_PROVIDERS.register("item_damage", new IColormapNumberProvider(){

        @Override
        public float getValue(@Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
            if (stack == null) {
                return 0.0f;
            }
            return 1.0f - (float)stack.method_7919() / (float)stack.method_7936();
        }

        @Override
        public boolean usesBiome() {
            return false;
        }

        @Override
        public boolean usesPos() {
            return false;
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapNumberProvider SEASON = BUILTIN_PROVIDERS.register("season", new IColormapNumberProvider(){

        @Override
        public float getValue(@Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
            return 1.0f - ClientFrameTicker.getSeason();
        }

        @Override
        public boolean usesBiome() {
            return false;
        }

        @Override
        public boolean usesPos() {
            return false;
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });

    public float getValue(@Nullable class_2680 var1, @Nullable class_2338 var2, @Nullable class_1959 var3, @Nullable BiomeIdMapper var4, @Nullable class_1799 var5);

    default public boolean usesBiome() {
        return true;
    }

    default public boolean usesPos() {
        return true;
    }

    default public boolean usesState() {
        return true;
    }

    default public IColormapNumberProvider createConcurrent() {
        return this;
    }

    public record Const(float c) implements IColormapNumberProvider
    {
        @Override
        public float getValue(class_2680 state, @NotNull class_2338 pos, @Nullable class_1959 biome, @Nullable BiomeIdMapper mapper, @Nullable class_1799 stack) {
            return this.c;
        }

        @Override
        public boolean usesState() {
            return false;
        }

        @Override
        public boolean usesBiome() {
            return false;
        }

        @Override
        public boolean usesPos() {
            return false;
        }
    }
}

