/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.particle.CustomParticleType;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.mehvahdjukaar.polytone.utils.exp.IExpression;
import net.mehvahdjukaar.polytone.utils.exp.PolytoneExpression;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_703;

public class ParticleContextExpression
extends PolytoneExpression {
    private static final String COLOR = "COLOR";
    private static final String SPEED = "SPEED";
    private static final String X = "X";
    private static final String Y = "Y";
    private static final String Z = "Z";
    private static final String DX = "DX";
    private static final String DY = "DY";
    private static final String DZ = "DZ";
    private static final String RED = "RED";
    private static final String GREEN = "GREEN";
    private static final String BLUE = "BLUE";
    private static final String ALPHA = "ALPHA";
    private static final String SIZE = "SIZE";
    private static final String LIFE = "LIFETIME";
    private static final String AGE = "AGE";
    private static final String ROLL = "ROLL";
    private static final String CUSTOM = "CUSTOM";
    public static final Codec<ParticleContextExpression> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            return DataResult.success((Object)new ParticleContextExpression((String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.getUnparsed()));
    private final boolean hasCustom;
    public static final ParticleContextExpression ZERO = new ParticleContextExpression("0");
    public static final ParticleContextExpression ONE = new ParticleContextExpression("1");
    public static final ParticleContextExpression PARTICLE_RAND = new ParticleContextExpression("(rand() * 2.0 - 1.0) * 0.4");

    public ParticleContextExpression(String expression) {
        this(expression, false);
    }

    public ParticleContextExpression(String expression, boolean concurrent) {
        super(expression, concurrent);
        this.hasCustom = expression.contains(CUSTOM);
    }

    @Override
    protected ParticleContextExpression createConcurrent() {
        return new ParticleContextExpression(this.getUnparsed(), true);
    }

    @Override
    protected void buildFunctions(PolytoneExpression.FunBuilder builder) {
        super.buildFunctions(builder);
    }

    @Override
    protected void buildVars(PolytoneExpression.VarBuilder builder) {
        super.buildVars(builder);
        builder.addAll(COLOR, SPEED, X, Y, Z, DX, DY, DZ, RED, GREEN, BLUE, ALPHA, SIZE, LIFE, AGE, ROLL, CUSTOM);
    }

    public double getValue(class_703 particle, class_1937 level) {
        class_1297 e;
        IExpression.IVars vb = this.expression.varBuilder();
        vb.setVariable(LIFE, particle.method_3082());
        int pack = ColorUtils.pack(particle.field_3861, particle.field_3842, particle.field_3859);
        vb.setVariable(COLOR, pack);
        vb.setVariable(RED, particle.field_3861);
        vb.setVariable(GREEN, particle.field_3842);
        vb.setVariable(BLUE, particle.field_3859);
        vb.setVariable(SPEED, class_3532.method_33825((double)particle.field_3852, (double)particle.field_3869, (double)particle.field_3850));
        vb.setVariable(ALPHA, particle.field_3841);
        vb.setVariable(SIZE, ((class_3940)particle).field_17867);
        vb.setVariable(DX, particle.field_3852);
        vb.setVariable(DY, particle.field_3869);
        vb.setVariable(DZ, particle.field_3850);
        vb.setVariable(X, particle.field_3874);
        vb.setVariable(Y, particle.field_3854);
        vb.setVariable(Z, particle.field_3871);
        vb.setVariable(AGE, particle.field_3866);
        vb.setVariable(ROLL, particle.field_3839);
        if (this.hasCustom && particle instanceof CustomParticleType.Instance) {
            CustomParticleType.Instance i = (CustomParticleType.Instance)particle;
            vb.setVariable(CUSTOM, i.getCustom());
        }
        class_2338 pos = class_2338.method_49637((double)particle.field_3874, (double)particle.field_3854, (double)particle.field_3871);
        if (this.hasPos) {
            vb.setVariable("POS_X", pos.method_10263());
            vb.setVariable("POS_Y", pos.method_10264());
            vb.setVariable("POS_Z", pos.method_10260());
        }
        if (this.hasTime) {
            vb.setVariable("TIME", ClientFrameTicker.getGameTime());
        }
        if (this.hasDayTime) {
            vb.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
        }
        if (this.hasSunTime) {
            vb.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
        }
        if (this.hasRain) {
            vb.setVariable("RAIN", ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasSeason) {
            vb.setVariable("SEASON", ClientFrameTicker.getSeason());
        }
        if (this.hasSkyLight) {
            vb.setVariable("SKY_LIGHT", level.method_8314(class_1944.field_9284, pos));
        }
        if (this.hasBlockLight) {
            vb.setVariable("BLOCK_LIGHT", level.method_8314(class_1944.field_9282, pos));
        }
        if (this.hasTemperature) {
            vb.setVariable("TEMPERATURE", ClientFrameTicker.getTemperature());
        }
        if (this.hasDownfall) {
            vb.setVariable("DOWNFALL", ClientFrameTicker.getDownfall());
        }
        if (this.hasPlayer) {
            e = class_310.method_1551().method_1560();
            vb.setVariable("PLAYER_X", e.method_23317());
            vb.setVariable("PLAYER_Y", e.method_23318());
            vb.setVariable("PLAYER_Z", e.method_23321());
        }
        if (this.hasDistance) {
            e = class_310.method_1551().method_1560();
            double x = particle.field_3874 - e.method_23317();
            double y = particle.field_3854 - e.method_23318();
            double z = particle.field_3871 - e.method_23321();
            vb.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
        }
        if (this.hasPlayerSpeed) {
            vb.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
        }
        if (this.hasRenderDistance) {
            vb.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
        }
        ExpressionUtils.randomizeRandom();
        return this.expression.evaluate(vb);
    }
}

