/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.mehvahdjukaar.polytone.utils.exp.IExpression;
import net.mehvahdjukaar.polytone.utils.exp.PolytoneExpression;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BlockContextExpression
extends PolytoneExpression {
    public static final Codec<BlockContextExpression> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            return DataResult.success((Object)new BlockContextExpression((String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.getUnparsed()));
    private final boolean hasState;
    public static final BlockContextExpression ZERO = new BlockContextExpression("0");
    public static final BlockContextExpression ONE = new BlockContextExpression("1");
    public static final BlockContextExpression PARTICLE_RAND = new BlockContextExpression("(rand() * 2.0 - 1.0) * 0.4");

    public BlockContextExpression(String unparsed) {
        this(unparsed, false);
    }

    public BlockContextExpression(String unparsed, boolean concurrent) {
        super(unparsed, concurrent);
        this.hasState = unparsed.contains("state_prop");
    }

    @Override
    protected BlockContextExpression createConcurrent() {
        return new BlockContextExpression(this.getUnparsed(), true);
    }

    @Override
    protected void buildFunctions(PolytoneExpression.FunBuilder builder) {
        super.buildFunctions(builder);
        builder.add(STATE_PROP);
        builder.add(STATE_PROP_INT);
    }

    public double getValue(Vec3 pos, float entityTime, Level level) {
        Entity e;
        ExpressionUtils.randomizeRandom();
        IExpression.IVars vb = this.expression.varBuilder();
        if (this.hasPos) {
            vb.setVariable("POS_X", pos.f_82479_);
            vb.setVariable("POS_Y", pos.f_82480_);
            vb.setVariable("POS_Z", pos.f_82481_);
        }
        BlockPos p = BlockPos.m_274446_((Position)pos);
        if (this.hasTime) {
            vb.setVariable("TIME", entityTime);
        }
        if (this.hasDayTime) {
            vb.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
        }
        if (this.hasSunTime) {
            vb.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
        }
        if (this.hasRain) {
            vb.setVariable("RAIN", ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasSkyLight) {
            vb.setVariable("SKY_LIGHT", level.m_45517_(LightLayer.SKY, p));
        }
        if (this.hasBlockLight) {
            vb.setVariable("BLOCK_LIGHT", level.m_45517_(LightLayer.BLOCK, p));
        }
        if (this.hasTemperature) {
            vb.setVariable("TEMPERATURE", ColorUtils.getClimateSettings((Biome)((Biome)level.m_204166_((BlockPos)p).m_203334_())).f_47681_);
        }
        if (this.hasDownfall) {
            vb.setVariable("DOWNFALL", ColorUtils.getClimateSettings((Biome)((Biome)level.m_204166_((BlockPos)p).m_203334_())).f_47683_);
        }
        if (this.hasState) {
            STATE_HACK.set(level.m_8055_(p));
        }
        if (this.hasPlayer) {
            e = Minecraft.m_91087_().m_91288_();
            vb.setVariable("PLAYER_X", e.m_20185_());
            vb.setVariable("PLAYER_Y", e.m_20186_());
            vb.setVariable("PLAYER_Z", e.m_20189_());
        }
        if (this.hasDistance) {
            e = Minecraft.m_91087_().m_91288_();
            double x = pos.f_82479_ - e.m_20185_();
            double y = pos.f_82480_ - e.m_20186_();
            double z = pos.f_82481_ - e.m_20189_();
            vb.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
        }
        if (this.hasPlayerSpeed) {
            vb.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
        }
        if (this.hasRenderDistance) {
            vb.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
        }
        return this.expression.evaluate(vb);
    }

    public double getValue(Level level, @NotNull BlockPos pos, BlockState state) {
        Entity e;
        ExpressionUtils.seedRandom(state.m_60726_(pos));
        IExpression.IVars vars = this.expression.varBuilder();
        if (this.hasPos) {
            vars.setVariable("POS_X", pos.m_123341_());
            vars.setVariable("POS_Y", pos.m_123342_());
            vars.setVariable("POS_Z", pos.m_123343_());
        }
        if (this.hasTime) {
            vars.setVariable("TIME", ClientFrameTicker.getGameTime());
        }
        if (this.hasDayTime) {
            vars.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
        }
        if (this.hasSunTime) {
            vars.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
        }
        if (this.hasRain) {
            vars.setVariable("RAIN", ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasSkyLight) {
            vars.setVariable("SKY_LIGHT", level.m_45517_(LightLayer.SKY, pos));
        }
        if (this.hasBlockLight) {
            vars.setVariable("BLOCK_LIGHT", level.m_45517_(LightLayer.BLOCK, pos));
        }
        if (this.hasTemperature) {
            vars.setVariable("TEMPERATURE", ColorUtils.getClimateSettings((Biome)((Biome)level.m_204166_((BlockPos)pos).m_203334_())).f_47681_);
        }
        if (this.hasDownfall) {
            vars.setVariable("DOWNFALL", ColorUtils.getClimateSettings((Biome)((Biome)level.m_204166_((BlockPos)pos).m_203334_())).f_47683_);
        }
        if (this.hasState) {
            STATE_HACK.set(state);
        }
        if (this.hasPlayer) {
            e = Minecraft.m_91087_().m_91288_();
            vars.setVariable("PLAYER_X", e.m_20185_());
            vars.setVariable("PLAYER_Y", e.m_20186_());
            vars.setVariable("PLAYER_Z", e.m_20189_());
        }
        if (this.hasDistance) {
            e = Minecraft.m_91087_().m_91288_();
            double x = (double)pos.m_123341_() - e.m_20185_();
            double y = (double)pos.m_123342_() - e.m_20186_();
            double z = (double)pos.m_123343_() - e.m_20189_();
            vars.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
        }
        if (this.hasPlayerSpeed) {
            vars.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
        }
        if (this.hasRenderDistance) {
            vars.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
        }
        return this.expression.evaluate(vars);
    }
}

