/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.colormap.IColormapNumberProvider;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.mehvahdjukaar.polytone.utils.exp.IExpression;
import net.mehvahdjukaar.polytone.utils.exp.PolytoneExpression;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ColormapExpressionProvider
extends PolytoneExpression
implements IColormapNumberProvider {
    protected static final String BIOME_VALUE = "BIOME_VALUE";
    protected static final String DAMAGE = "DAMAGE";
    public static final Codec<ColormapExpressionProvider> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            return DataResult.success((Object)new ColormapExpressionProvider((String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.getUnparsed()));
    protected final boolean usesBiome;
    protected final boolean hasState;

    protected ColormapExpressionProvider(String unparsed) {
        this(unparsed, false);
    }

    protected ColormapExpressionProvider(String unparsed, boolean concurrent) {
        super(unparsed, concurrent);
        this.usesBiome = unparsed.contains("TEMPERATURE") || unparsed.contains("DOWNFALL") || unparsed.contains(BIOME_VALUE);
        this.hasState = unparsed.contains("state_prop");
    }

    @Override
    public ColormapExpressionProvider createConcurrent() {
        return new ColormapExpressionProvider(this.getUnparsed(), true);
    }

    @Override
    protected void buildVars(PolytoneExpression.VarBuilder builder) {
        super.buildVars(builder);
        builder.addAll(BIOME_VALUE, DAMAGE);
    }

    @Override
    protected void buildFunctions(PolytoneExpression.FunBuilder builder) {
        super.buildFunctions(builder);
        builder.addAll(STATE_PROP_INT, STATE_PROP);
    }

    @Override
    public boolean usesBiome() {
        return this.usesBiome;
    }

    @Override
    public boolean usesPos() {
        return this.hasPos;
    }

    @Override
    public boolean usesState() {
        return this.hasState;
    }

    @Override
    public float getValue(@Nullable BlockState state, @Nullable BlockPos pos, @Nullable Biome biome, @Nullable BiomeIdMapper mapper, @Nullable ItemStack stack) {
        Entity e;
        if (pos == null) {
            pos = BlockPos.f_121853_;
            ExpressionUtils.randomizeRandom();
        } else {
            ExpressionUtils.seedRandom((long)pos.hashCode() * pos.m_121878_());
        }
        IExpression.IVars vb = this.expression.varBuilder();
        if (this.hasPos) {
            vb.setVariable("POS_X", pos.m_123341_());
            vb.setVariable("POS_Y", pos.m_123342_());
            vb.setVariable("POS_Z", pos.m_123343_());
        }
        if (this.hasTime) {
            vb.setVariable("TIME", ClientFrameTicker.getGameTime());
        }
        if (this.hasDayTime) {
            vb.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
        }
        if (this.hasSunTime) {
            vb.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
        }
        if (this.hasRain) {
            vb.setVariable("RAIN", ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasSkyLight) {
            vb.setVariable("SKY_LIGHT", Minecraft.m_91087_().f_91073_.m_45517_(LightLayer.SKY, pos));
        }
        if (this.hasBlockLight) {
            vb.setVariable("BLOCK_LIGHT", Minecraft.m_91087_().f_91073_.m_45517_(LightLayer.BLOCK, pos));
        }
        if (this.hasTemperature) {
            vb.setVariable("TEMPERATURE", biome != null ? (double)ColorUtils.getClimateSettings((Biome)biome).f_47681_ : 0.0);
        }
        if (this.hasDownfall) {
            vb.setVariable("DOWNFALL", biome != null ? (double)ColorUtils.getClimateSettings((Biome)biome).f_47683_ : 0.0);
        }
        if (this.hasPlayer) {
            e = Minecraft.m_91087_().m_91288_();
            vb.setVariable("PLAYER_X", e.m_20185_());
            vb.setVariable("PLAYER_Y", e.m_20186_());
            vb.setVariable("PLAYER_Z", e.m_20189_());
        }
        if (this.hasDistance) {
            e = Minecraft.m_91087_().m_91288_();
            double x = (double)pos.m_123341_() - e.m_20185_();
            double y = (double)pos.m_123342_() - e.m_20186_();
            double z = (double)pos.m_123343_() - e.m_20189_();
            vb.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
        }
        if (this.hasPlayerSpeed) {
            vb.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
        }
        if (this.hasRenderDistance) {
            vb.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
        }
        if (stack != null) {
            float damage = 1.0f - (float)stack.m_41773_() / (float)stack.m_41776_();
            vb.setVariable(DAMAGE, damage);
        } else {
            vb.setVariable(DAMAGE, 0.0);
        }
        if (this.hasState) {
            STATE_HACK.set(state);
        }
        float result = (float)this.expression.evaluate(vb);
        STATE_HACK.remove();
        return result;
    }
}

