/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.serialization.Codec;
import java.util.Locale;
import net.mehvahdjukaar.polytone.particle.RotationProvider;
import net.minecraft.client.Camera;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public enum RotationMode implements StringRepresentable,
RotationProvider
{
    LOOK_AT_XYZ,
    LOOK_AT_Y,
    LOOK_AT_X,
    LOOK_AT_Z,
    LOOK_AT_XZ,
    MOVEMENT_ALIGNED,
    LOOK_UP,
    LOOK_WEST,
    NONE;

    public static final Codec<RotationMode> CODEC;

    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public void applyRotation(SingleQuadParticle particle, Quaternionf quaternionf, Camera camera, float partialTicks) {
        switch (this.ordinal()) {
            case 8: {
                break;
            }
            case 6: {
                quaternionf.identity();
                quaternionf.rotateX(1.5707964f);
                break;
            }
            case 7: {
                quaternionf.identity();
                quaternionf.rotateY(1.5707964f);
                break;
            }
            case 0: {
                FacingCameraMode.LOOKAT_XYZ.setRotation(quaternionf, camera, partialTicks);
                break;
            }
            case 1: {
                FacingCameraMode.LOOKAT_Y.setRotation(quaternionf, camera, partialTicks);
                break;
            }
            case 2: {
                quaternionf.set(camera.m_253121_().x, 0.0f, 0.0f, camera.m_253121_().w);
                break;
            }
            case 3: {
                quaternionf.set(0.0f, 0.0f, camera.m_253121_().z, camera.m_253121_().w);
                break;
            }
            case 4: {
                quaternionf.set(camera.m_253121_().x, 0.0f, camera.m_253121_().z, camera.m_253121_().w);
                break;
            }
            case 5: {
                Vec3 dir = new Vec3(particle.f_107215_, particle.f_107216_, particle.f_107217_).m_82541_();
                Vec3 cameraLook = new Vec3(camera.m_253058_());
                Vec3 cross = dir.m_82537_(cameraLook);
                double pitch = RotationMode.getPitch(dir);
                double yaw = RotationMode.getYaw(dir);
                Vector3f dirUp = new Vector3f(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)quaternionf);
                float roll = dirUp.angleSigned((Vector3fc)cross.m_252839_(), (Vector3fc)dir.m_252839_());
                quaternionf.rotateY((float)(-0.01745329238474369 * yaw));
                quaternionf.rotateX((float)(0.01745329238474369 * (pitch - 90.0)));
                quaternionf.rotateY(-roll - 1.5707964f);
            }
        }
    }

    @Override
    public boolean alwaysFacesCamera() {
        return this == LOOK_AT_XYZ || this == LOOK_AT_Y || this == MOVEMENT_ALIGNED;
    }

    public static double getPitch(Vec3 vec3) {
        return -Math.toDegrees(Math.asin(vec3.f_82480_));
    }

    public static double getYaw(Vec3 vec3) {
        return Math.toDegrees(Math.atan2(-vec3.f_82479_, vec3.f_82481_));
    }

    static {
        CODEC = StringRepresentable.m_216439_(RotationMode::values);
    }

    public static interface FacingCameraMode {
        public static final FacingCameraMode LOOKAT_XYZ = (quaternionf, camera, f) -> quaternionf.set((Quaternionfc)camera.m_253121_());
        public static final FacingCameraMode LOOKAT_Y = (quaternionf, camera, f) -> quaternionf.set(0.0f, camera.m_253121_().y, 0.0f, camera.m_253121_().w);

        public void setRotation(Quaternionf var1, Camera var2, float var3);
    }
}

