/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.slotify.IntRange;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;

public record WidgetModifier(int xOffset, int yOffset, int width, Optional<String> message, Optional<IntRange> targetX, Optional<IntRange> targetY, Optional<IntRange> targetW, Optional<IntRange> targetH, Optional<String> targetMessage, Optional<String> targetClass) {
    public static final Codec<WidgetModifier> CODEC = RecordCodecBuilder.create(i -> i.group((App)StrOpt.of(Codec.INT, "x_offset", 0).forGetter(WidgetModifier::xOffset), (App)StrOpt.of(Codec.INT, "y_offset", 0).forGetter(WidgetModifier::yOffset), (App)StrOpt.of(Codec.INT, "width_increment", 0).forGetter(WidgetModifier::width), (App)StrOpt.of(Codec.STRING, "message").forGetter(WidgetModifier::message), (App)StrOpt.of(IntRange.CODEC, "target_x").forGetter(WidgetModifier::targetX), (App)StrOpt.of(IntRange.CODEC, "target_y").forGetter(WidgetModifier::targetY), (App)StrOpt.of(IntRange.CODEC, "target_width").forGetter(WidgetModifier::targetY), (App)StrOpt.of(IntRange.CODEC, "target_height").forGetter(WidgetModifier::targetY), (App)StrOpt.of(Codec.STRING, "target_message").forGetter(WidgetModifier::targetMessage), (App)StrOpt.of(Codec.STRING.xmap(PlatStuff::maybeRemapName, PlatStuff::maybeRemapName), "target_class_name").forGetter(WidgetModifier::targetClass)).apply((Applicative)i, WidgetModifier::new)).comapFlatMap(o -> {
        if (o.targetW.isEmpty() && o.targetH.isEmpty() && o.targetX.isEmpty() && o.targetClass.isEmpty() && o.targetY.isEmpty() && o.targetMessage.isEmpty()) {
            return DataResult.error(() -> "Widget modifier must have at least one target");
        }
        return DataResult.success((Object)o);
    }, Function.identity());

    public void maybeModify(AbstractWidget widget) {
        if (this.targetX.isPresent() && !this.targetX.get().has(widget.m_252754_())) {
            return;
        }
        if (this.targetY.isPresent() && !this.targetY.get().has(widget.m_252907_())) {
            return;
        }
        if (this.targetH.isPresent() && !this.targetH.get().has(widget.m_93694_())) {
            return;
        }
        if (this.targetW.isPresent() && !this.targetW.get().has(widget.m_5711_())) {
            return;
        }
        if (this.targetMessage.isPresent() && !widget.m_6035_().getString().equals(this.targetMessage.get())) {
            return;
        }
        if (this.targetClass.isPresent()) {
            String name = this.targetClass.get();
            if (!widget.getClass().getSimpleName().equals(name) && !widget.getClass().getName().equals(name)) {
                return;
            }
        }
        widget.m_252865_(widget.m_252754_() + this.xOffset);
        widget.m_253211_(widget.m_252907_() + this.yOffset);
        widget.m_93674_(widget.m_5711_() + this.width);
        this.message.ifPresent(s -> widget.m_93666_((Component)Component.m_237115_((String)s)));
    }
}

