/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.tabs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.tabs.ItemAddition;
import net.mehvahdjukaar.polytone.tabs.ItemPredicate;
import net.mehvahdjukaar.polytone.tabs.ItemToTabEvent;
import net.mehvahdjukaar.polytone.utils.CodecUtil;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.mehvahdjukaar.polytone.utils.Utils;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record CreativeTabModifier(Optional<ItemStack> icon, Optional<Boolean> search, Optional<Integer> searchWidth, Optional<Boolean> canScroll, Optional<Boolean> showTitle, Optional<Component> name, Optional<ResourceLocation> backGroundLocation, Optional<ResourceLocation> tabsImage, Optional<List<ResourceLocation>> beforeTabs, Optional<List<ResourceLocation>> afterTabs, List<ItemPredicate> removals, List<ItemAddition> additions, boolean registerTab, Targets targets) {
    public static final Codec<Component> COMPONENT_CODEC = Codec.either((Codec)ExtraCodecs.f_252442_, (Codec)ExtraCodecs.f_276686_).xmap(e -> (Component)e.map(Function.identity(), Function.identity()), Either::left);
    public static final Codec<CreativeTabModifier> CODEC = ExtraCodecs.m_264370_((Codec)RecordCodecBuilder.create(i -> i.group((App)StrOpt.of(CodecUtil.ITEM_OR_STACK, "icon").forGetter(CreativeTabModifier::icon), (App)StrOpt.of(Codec.BOOL, "search_bar").forGetter(CreativeTabModifier::search), (App)StrOpt.of(Codec.INT, "search_bar_width").forGetter(CreativeTabModifier::searchWidth), (App)StrOpt.of(Codec.BOOL, "can_scroll").forGetter(CreativeTabModifier::canScroll), (App)StrOpt.of(Codec.BOOL, "show_title").forGetter(CreativeTabModifier::showTitle), (App)StrOpt.of(COMPONENT_CODEC, "name").forGetter(CreativeTabModifier::name), (App)StrOpt.of(ResourceLocation.f_135803_, "background").forGetter(CreativeTabModifier::backGroundLocation), (App)StrOpt.of(ResourceLocation.f_135803_, "tabs_image").forGetter(CreativeTabModifier::tabsImage), (App)StrOpt.of(ResourceLocation.f_135803_.listOf(), "before_tabs").forGetter(CreativeTabModifier::beforeTabs), (App)StrOpt.of(ResourceLocation.f_135803_.listOf(), "after_tabs").forGetter(CreativeTabModifier::afterTabs), (App)StrOpt.of(ItemPredicate.CODEC.listOf(), "removals", List.of()).forGetter(CreativeTabModifier::removals), (App)StrOpt.of(ItemAddition.CODEC.listOf(), "additions", List.of()).forGetter(CreativeTabModifier::additions), (App)Codec.BOOL.optionalFieldOf("create_new", (Object)false).forGetter(CreativeTabModifier::registerTab), (App)Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).forGetter(CreativeTabModifier::targets)).apply((Applicative)i, CreativeTabModifier::new)), m -> {
        if (m.registerTab && (!m.removals.isEmpty() || m.targets != Targets.EMPTY)) {
            return DataResult.error(() -> "Modifiers that register new creative tabs cannot have item removals or target existing tabs.");
        }
        return DataResult.success((Object)m);
    });

    public CreativeTabModifier merge(CreativeTabModifier newMod) {
        return new CreativeTabModifier(newMod.icon.isPresent() ? newMod.icon : this.icon, newMod.search.isPresent() ? newMod.search : this.search, newMod.searchWidth.isPresent() ? newMod.searchWidth : this.searchWidth, newMod.canScroll.isPresent() ? newMod.canScroll : this.canScroll, newMod.showTitle.isPresent() ? newMod.showTitle : this.showTitle, newMod.name.isPresent() ? newMod.name : this.name, newMod.backGroundLocation.isPresent() ? newMod.backGroundLocation : this.backGroundLocation, newMod.tabsImage.isPresent() ? newMod.tabsImage : this.tabsImage, newMod.beforeTabs.isPresent() ? newMod.beforeTabs : this.beforeTabs, newMod.afterTabs.isPresent() ? newMod.afterTabs : this.afterTabs, Utils.mergeList(newMod.removals, this.removals), Utils.mergeList(newMod.additions, this.additions), this.registerTab || newMod.registerTab, this.targets.merge(newMod.targets));
    }

    public CreativeTabModifier applyItemsAndAttributes(ItemToTabEvent event, RegistryAccess access) {
        for (ItemPredicate itemPredicate : this.removals) {
            event.removeItems(itemPredicate);
        }
        for (ItemAddition itemAddition : this.additions) {
            List<ItemStack> stacks = itemAddition.items().get();
            if (stacks == null) continue;
            if (itemAddition.inverse()) {
                ArrayList<ItemStack> newList = new ArrayList<ItemStack>();
                List<Item> not = stacks.stream().map(ItemStack::m_41720_).toList();
                for (Item i : BuiltInRegistries.f_257033_) {
                    if (not.contains(i)) continue;
                    newList.add(i.m_7968_());
                }
                stacks = newList;
            }
            if (itemAddition.before()) {
                event.addBefore((Predicate<ItemStack>)itemAddition.predicate(), (ItemStack[])stacks.toArray(ItemStack[]::new));
                continue;
            }
            event.addAfter((Predicate<ItemStack>)itemAddition.predicate(), (ItemStack[])stacks.toArray(ItemStack[]::new));
        }
        return this.applyAttributes(event.getTab());
    }

    public CreativeTabModifier applyAttributes(ResourceKey<CreativeModeTab> key) {
        CreativeModeTab tab = (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(key);
        if (tab == null) {
            Polytone.LOGGER.error("Could not find creative mode tab with ID {}. What?", key);
        }
        return PlatStuff.modifyTab(this, tab);
    }
}

