/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.tabs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.mehvahdjukaar.polytone.utils.CodecUtil;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.mehvahdjukaar.polytone.utils.codec.CodecUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public interface ItemPredicate
extends Predicate<ItemStack> {
    public static final MapRegistry.CodecMap<ItemPredicate> TYPES = MapRegistry.ofCodec("Polytone Item Predicates");
    public static final Codec<ItemPredicate> CODEC = TYPES.dispatch("type", ItemPredicate::getCodec, Function.identity());
    public static final True TRUE_PRED = new True();
    public static final Codec<True> TRUE = TYPES.register("true", Codec.unit((Object)TRUE_PRED));
    public static final Codec<And> AND = TYPES.register("and", CODEC.listOf().fieldOf("predicates").xmap(And::new, And::predicates).codec());
    public static final Codec<Or> OR = TYPES.register("or", CODEC.listOf().fieldOf("predicates").xmap(Or::new, Or::predicates).codec());
    public static final Codec<Not> NOT = TYPES.register("not", CODEC.fieldOf("predicate").xmap(Not::new, Not::predicate).codec());
    public static final Codec<TagMatch> TAG_MATCH = TYPES.register("tag_match", TagKey.m_203877_((ResourceKey)Registries.f_256913_).fieldOf("tag").xmap(TagMatch::new, TagMatch::tag).codec());
    public static final Codec<ItemMatch> ITEM_MATCH = TYPES.register("items_match", CodecUtils.forwardAwareByNameCodec(BuiltInRegistries.f_257033_, Items.f_41852_).listOf().fieldOf("items").xmap(ItemMatch::new, ItemMatch::items).codec());
    public static final Codec<ItemStackMatch> ITEMSTACK_MATCH = TYPES.register("itemstack_match", CodecUtil.ITEMSTACK.fieldOf("itemstack").xmap(ItemStackMatch::new, ItemStackMatch::items).codec());
    public static final Pattern TRUE_PATTERN = Pattern.compile(".*");
    public static final Codec<IDMatch> ID_MATCH = TYPES.register("id_match", RecordCodecBuilder.create(i -> i.group((App)StrOpt.of(ExtraCodecs.f_216158_, "namespace", TRUE_PATTERN).forGetter(IDMatch::namespace), (App)StrOpt.of(ExtraCodecs.f_216158_, "path", TRUE_PATTERN).forGetter(IDMatch::path)).apply((Applicative)i, IDMatch::new)));

    public Codec<? extends ItemPredicate> getCodec();

    public static class True
    implements ItemPredicate {
        @Override
        public boolean test(ItemStack stack) {
            return true;
        }

        public Codec<True> getCodec() {
            return TRUE;
        }
    }

    public record IDMatch(Pattern namespace, Pattern path) implements ItemPredicate
    {
        @Override
        public boolean test(ItemStack stack) {
            Item item = stack.m_41720_();
            ResourceLocation id = item.m_204114_().m_205785_().m_135782_();
            return this.namespace.matcher(id.m_135827_()).find() && this.path.matcher(id.m_135815_()).find();
        }

        public Codec<IDMatch> getCodec() {
            return ID_MATCH;
        }
    }

    public record ItemStackMatch(ItemStack items) implements ItemPredicate
    {
        @Override
        public boolean test(ItemStack stack) {
            return ItemStack.m_41728_((ItemStack)this.items, (ItemStack)stack);
        }

        public Codec<ItemStackMatch> getCodec() {
            return ITEMSTACK_MATCH;
        }
    }

    public record ItemMatch(List<Item> items) implements ItemPredicate
    {
        @Override
        public boolean test(ItemStack stack) {
            return this.items.contains(stack.m_41720_());
        }

        public Codec<ItemMatch> getCodec() {
            return ITEM_MATCH;
        }
    }

    public record TagMatch(TagKey<Item> tag) implements ItemPredicate
    {
        @Override
        public boolean test(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }

        public Codec<TagMatch> getCodec() {
            return TAG_MATCH;
        }
    }

    public record Not(ItemPredicate predicate) implements ItemPredicate
    {
        @Override
        public boolean test(ItemStack stack) {
            return !this.predicate.test(stack);
        }

        public Codec<Not> getCodec() {
            return NOT;
        }
    }

    public record Or(List<ItemPredicate> predicates) implements ItemPredicate
    {
        @Override
        public boolean test(ItemStack stack) {
            return this.predicates.stream().anyMatch(p -> p.test(stack));
        }

        public Codec<Or> getCodec() {
            return OR;
        }
    }

    public record And(List<ItemPredicate> predicates) implements ItemPredicate
    {
        @Override
        public boolean test(ItemStack stack) {
            return this.predicates.stream().allMatch(p -> p.test(stack));
        }

        @Override
        public Codec<? extends ItemPredicate> getCodec() {
            return AND;
        }
    }
}

