/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.utils.AlternativeMapCodec;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.mehvahdjukaar.polytone.utils.Weather;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_3414;
import net.minecraft.class_3542;
import net.minecraft.class_4761;
import net.minecraft.class_4763;
import net.minecraft.class_4967;
import net.minecraft.class_4968;
import net.minecraft.class_5195;
import net.minecraft.class_6880;

public record BiomeEffectModifier(Optional<Integer> fogColor, Optional<Integer> waterColor, Optional<Integer> waterFogColor, Optional<Integer> skyColor, Optional<Integer> foliageColorOverride, Optional<Integer> grassColorOverride, Optional<class_4763.class_5486> grassColorModifier, Optional<class_4761> ambientParticleSettings, Optional<class_6880<class_3414>> ambientLoopSoundEvent, Optional<class_4968> ambientMoodSettings, Optional<class_4967> ambientAdditionsSettings, Optional<class_5195> backgroundMusic, Optional<FogParam> fogStart, Optional<FogParam> fogEnd, Targets targets) {
    public static final Codec<BiomeEffectModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("fog_color").forGetter(BiomeEffectModifier::fogColor), (App)Codec.INT.optionalFieldOf("water_color").forGetter(BiomeEffectModifier::waterColor), (App)Codec.INT.optionalFieldOf("water_fog_color").forGetter(BiomeEffectModifier::waterFogColor), (App)Codec.INT.optionalFieldOf("sky_color").forGetter(BiomeEffectModifier::skyColor), (App)Codec.INT.optionalFieldOf("foliage_color").forGetter(BiomeEffectModifier::foliageColorOverride), (App)Codec.INT.optionalFieldOf("grass_color").forGetter(BiomeEffectModifier::grassColorOverride), (App)class_4763.class_5486.field_26429.optionalFieldOf("grass_color_modifier").forGetter(BiomeEffectModifier::grassColorModifier), (App)class_4761.field_24675.optionalFieldOf("particle").forGetter(BiomeEffectModifier::ambientParticleSettings), (App)class_3414.field_41699.optionalFieldOf("ambient_sound").forGetter(BiomeEffectModifier::ambientLoopSoundEvent), (App)class_4968.field_24674.optionalFieldOf("mood_sound").forGetter(BiomeEffectModifier::ambientMoodSettings), (App)class_4967.field_24673.optionalFieldOf("additions_sound").forGetter(BiomeEffectModifier::ambientAdditionsSettings), (App)class_5195.field_24627.optionalFieldOf("music").forGetter(BiomeEffectModifier::backgroundMusic), (App)AlternativeMapCodec.optionalAlias(FogParam.CODEC, "fog_fade", "fog_start").forGetter(BiomeEffectModifier::fogStart), (App)AlternativeMapCodec.optionalAlias(FogParam.CODEC, "fog_radius", "fog_end").forGetter(BiomeEffectModifier::fogEnd), (App)Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).forGetter(BiomeEffectModifier::targets)).apply((Applicative)instance, BiomeEffectModifier::new));

    public static BiomeEffectModifier ofWaterColor(int waterColor) {
        return new BiomeEffectModifier(Optional.empty(), Optional.of(waterColor), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Targets.EMPTY);
    }

    public BiomeEffectModifier merge(BiomeEffectModifier newMod) {
        return new BiomeEffectModifier(newMod.fogColor.isPresent() ? newMod.fogColor() : this.fogColor(), newMod.waterColor().isPresent() ? newMod.waterColor() : this.waterColor(), newMod.waterFogColor().isPresent() ? newMod.waterFogColor() : this.waterFogColor(), newMod.skyColor().isPresent() ? newMod.skyColor() : this.skyColor(), newMod.foliageColorOverride().isPresent() ? newMod.waterColor() : this.foliageColorOverride(), newMod.grassColorOverride().isPresent() ? newMod.grassColorOverride() : this.grassColorOverride(), newMod.grassColorModifier().isPresent() ? newMod.grassColorModifier() : this.grassColorModifier(), newMod.ambientParticleSettings().isPresent() ? newMod.ambientParticleSettings() : this.ambientParticleSettings(), newMod.ambientLoopSoundEvent().isPresent() ? newMod.ambientLoopSoundEvent() : this.ambientLoopSoundEvent(), newMod.ambientMoodSettings().isPresent() ? newMod.ambientMoodSettings() : this.ambientMoodSettings(), newMod.ambientAdditionsSettings().isPresent() ? newMod.ambientAdditionsSettings() : this.ambientAdditionsSettings(), newMod.backgroundMusic().isPresent() ? newMod.backgroundMusic() : this.backgroundMusic(), newMod.fogStart().isPresent() ? newMod.fogStart() : this.fogStart(), newMod.fogEnd().isPresent() ? newMod.fogEnd() : this.fogEnd(), this.targets.merge(newMod.targets));
    }

    public class_4763 apply(class_1959 biome) {
        class_4763 effects = biome.method_24377();
        class_4763.class_4764 builder = this.getBuilder(effects);
        Optional<Integer> newFoliageColorOverride = effects.method_30811();
        if (this.foliageColorOverride.isPresent()) {
            newFoliageColorOverride = this.foliageColorOverride;
        }
        newFoliageColorOverride.ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_30821(arg_0));
        Optional<Integer> newGrassColorOverride = effects.method_30812();
        if (this.grassColorOverride.isPresent()) {
            newGrassColorOverride = this.grassColorOverride;
        }
        newGrassColorOverride.ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_30822(arg_0));
        class_4763.class_5486 newGrassColorModifier = effects.method_30814();
        if (this.grassColorModifier.isPresent()) {
            newGrassColorModifier = this.grassColorModifier.get();
        }
        builder.method_30818(newGrassColorModifier);
        Optional<class_4761> newParticle = effects.method_24390();
        if (this.ambientParticleSettings.isPresent()) {
            newParticle = this.ambientParticleSettings;
        }
        newParticle.ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_24393(arg_0));
        Optional<class_6880<class_3414>> newAmbientSound = effects.method_24939();
        if (this.ambientLoopSoundEvent.isPresent()) {
            newAmbientSound = this.ambientLoopSoundEvent;
        }
        newAmbientSound.ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_24942(arg_0));
        Optional<class_4968> newMood = effects.method_24940();
        if (this.ambientMoodSettings.isPresent()) {
            newMood = this.ambientMoodSettings;
        }
        newMood.ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_24943(arg_0));
        Optional<class_4967> newAdditions = effects.method_24941();
        if (this.ambientAdditionsSettings.isPresent()) {
            newAdditions = this.ambientAdditionsSettings;
        }
        newAdditions.ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_24944(arg_0));
        Optional<class_5195> newMusic = effects.method_27345();
        if (this.backgroundMusic.isPresent()) {
            newMusic = this.backgroundMusic;
        }
        newMusic.ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_27346(arg_0));
        class_4763 copy = this.copy(effects);
        BiomeEffectModifier.applyEffects(biome, builder.method_24391());
        return copy;
    }

    private class_4763.class_4764 getBuilder(class_4763 effects) {
        class_4763.class_4764 builder = new class_4763.class_4764();
        int newFog = effects.method_24387();
        if (this.fogColor.isPresent()) {
            newFog = this.fogColor.get();
        }
        builder.method_24392(newFog);
        int newWaterColor = effects.method_24388();
        if (this.waterColor.isPresent()) {
            newWaterColor = this.waterColor.get();
        }
        builder.method_24395(newWaterColor);
        int newWaterFogColor = effects.method_24389();
        if (this.waterFogColor.isPresent()) {
            newWaterFogColor = this.waterFogColor.get();
        }
        builder.method_24397(newWaterFogColor);
        int newSkyColor = effects.method_30810();
        if (this.skyColor.isPresent()) {
            newSkyColor = this.skyColor.get();
        }
        builder.method_30820(newSkyColor);
        return builder;
    }

    private class_4763 copy(class_4763 effects) {
        class_4763.class_4764 builder = new class_4763.class_4764();
        builder.method_24392(effects.method_24387());
        builder.method_24395(effects.method_24388());
        builder.method_24397(effects.method_24389());
        builder.method_30820(effects.method_30810());
        effects.method_30811().ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_30821(arg_0));
        effects.method_30812().ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_30822(arg_0));
        builder.method_30818(effects.method_30814());
        effects.method_24390().ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_24393(arg_0));
        effects.method_24939().ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_24942(arg_0));
        effects.method_24940().ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_24943(arg_0));
        effects.method_24941().ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_24944(arg_0));
        effects.method_27345().ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_27346(arg_0));
        return builder.method_24391();
    }

    public static void applyEffects(class_1959 biome, class_4763 newEffects) {
        PlatStuff.applyBiomeSurgery(biome, newEffects);
    }

    private static void applyInplace(class_1959 biome, class_4763 newEffects) {
        class_4763 oldEffects = biome.method_24377();
        oldEffects.field_22067 = -1;
        oldEffects.field_22068 = newEffects.method_24388();
        oldEffects.field_22069 = newEffects.method_24389();
        oldEffects.field_26418 = -1;
        oldEffects.field_26419 = newEffects.method_30811();
        oldEffects.field_26420 = Optional.of(-1);
        oldEffects.field_26421 = newEffects.method_30814();
        oldEffects.field_22070 = newEffects.method_24390();
        oldEffects.field_22491 = newEffects.method_24939();
        oldEffects.field_22492 = newEffects.method_24940();
        oldEffects.field_22493 = newEffects.method_24941();
        oldEffects.field_24113 = newEffects.method_27345();
    }

    public boolean modifyFogParameter() {
        return this.fogStart.isPresent() || this.fogEnd.isPresent();
    }

    public class_241 modifyFogParameters(class_1937 level) {
        return new class_241(this.fogStart.map(f -> Float.valueOf(f.get(level))).orElse(Float.valueOf(1.0f)).floatValue(), this.fogEnd.map(f -> Float.valueOf(f.get(level))).orElse(Float.valueOf(1.0f)).floatValue());
    }

    public static interface FogParam {
        public static final Codec<FogParam> SIMPLE_CODEC = Codec.FLOAT.xmap(f -> l -> f.floatValue(), fogParam -> Float.valueOf(fogParam.get(null)));
        public static final Codec<FogParam> CODEC = Codec.withAlternative((Codec)Codec.withAlternative(SIMPLE_CODEC, (Codec)Codec.simpleMap(Weather.CODEC, SIMPLE_CODEC, (Keyable)class_3542.method_28142((class_3542[])Weather.values())).xmap(FogMap::new, FogMap::map).codec()), (Codec)BlockContextExpression.CODEC.xmap(FogExpression::new, fogMap -> fogMap.map));

        public float get(class_1937 var1);
    }

    public record FogMap(Map<Weather, FogParam> map) implements FogParam
    {
        @Override
        public float get(class_1937 level) {
            Weather w = Weather.get(level);
            return this.map.getOrDefault((Object)w, l -> 1.0f).get(level);
        }
    }

    public record FogExpression(BlockContextExpression map) implements FogParam
    {
        @Override
        public float get(class_1937 level) {
            class_2338 pos = ClientFrameTicker.getCameraPos();
            return (float)this.map.getValue(level, pos, class_2246.field_10124.method_9564());
        }
    }
}

