/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.particle.CustomParticleType;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.mehvahdjukaar.polytone.utils.exp.BaseExpression;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_703;

public class ParticleContextExpression
extends BaseExpression {
    private static final String COLOR = "COLOR";
    private static final String SPEED = "SPEED";
    private static final String X = "X";
    private static final String Y = "Y";
    private static final String Z = "Z";
    private static final String DX = "DX";
    private static final String DY = "DY";
    private static final String DZ = "DZ";
    private static final String RED = "RED";
    private static final String GREEN = "GREEN";
    private static final String BLUE = "BLUE";
    private static final String ALPHA = "ALPHA";
    private static final String SIZE = "SIZE";
    private static final String LIFE = "LIFETIME";
    private static final String AGE = "AGE";
    private static final String ROLL = "ROLL";
    private static final String CUSTOM = "CUSTOM";
    public static final Codec<ParticleContextExpression> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            return DataResult.success((Object)new ParticleContextExpression((String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.getUnparsed()));
    private final boolean hasCustom;
    public static final ParticleContextExpression ZERO = new ParticleContextExpression("0");
    public static final ParticleContextExpression ONE = new ParticleContextExpression("1");
    public static final ParticleContextExpression PARTICLE_RAND = new ParticleContextExpression("(rand() * 2.0 - 1.0) * 0.4");

    public ParticleContextExpression(String expression) {
        super(expression);
        this.hasCustom = expression.contains(CUSTOM);
    }

    @Override
    protected void buildFunctions(BaseExpression.FunBuilder builder) {
        super.buildFunctions(builder);
    }

    @Override
    protected void buildVars(BaseExpression.VarBuilder builder) {
        super.buildVars(builder);
        builder.addAll(COLOR, SPEED, X, Y, Z, DX, DY, DZ, RED, GREEN, BLUE, ALPHA, SIZE, LIFE, AGE, ROLL, CUSTOM);
    }

    public double getValue(class_703 particle, class_1937 level) {
        class_1297 e;
        this.expression.setVariable(LIFE, particle.method_3082());
        int pack = ColorUtils.pack(particle.field_3861, particle.field_3842, particle.field_3859);
        this.expression.setVariable(COLOR, pack);
        this.expression.setVariable(RED, particle.field_3861);
        this.expression.setVariable(GREEN, particle.field_3842);
        this.expression.setVariable(BLUE, particle.field_3859);
        this.expression.setVariable(SPEED, class_3532.method_33825((double)particle.field_3852, (double)particle.field_3869, (double)particle.field_3850));
        this.expression.setVariable(ALPHA, particle.field_3841);
        this.expression.setVariable(SIZE, ((class_3940)particle).field_17867);
        this.expression.setVariable(DX, particle.field_3852);
        this.expression.setVariable(DY, particle.field_3869);
        this.expression.setVariable(DZ, particle.field_3850);
        this.expression.setVariable(X, particle.field_3874);
        this.expression.setVariable(Y, particle.field_3854);
        this.expression.setVariable(Z, particle.field_3871);
        this.expression.setVariable(AGE, particle.field_3866);
        this.expression.setVariable(ROLL, particle.field_3839);
        if (this.hasCustom && particle instanceof CustomParticleType.Instance) {
            CustomParticleType.Instance i = (CustomParticleType.Instance)particle;
            this.expression.setVariable(CUSTOM, i.getCustom());
        }
        if (this.hasPos) {
            class_2338 pos = class_2338.method_49637((double)particle.field_3874, (double)particle.field_3854, (double)particle.field_3871);
            this.expression.setVariable("POS_X", pos.method_10263());
            this.expression.setVariable("POS_Y", pos.method_10264());
            this.expression.setVariable("POS_Z", pos.method_10260());
        }
        if (this.hasTime) {
            this.expression.setVariable("TIME", ClientFrameTicker.getGameTime());
        }
        if (this.hasDayTime) {
            this.expression.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
        }
        if (this.hasSunTime) {
            this.expression.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
        }
        if (this.hasRain) {
            this.expression.setVariable("RAIN", ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasSkyLight) {
            this.expression.setVariable("SKY_LIGHT", ClientFrameTicker.getSkyLight());
        }
        if (this.hasBlockLight) {
            this.expression.setVariable("BLOCK_LIGHT", ClientFrameTicker.getBlockLight());
        }
        if (this.hasTemperature) {
            this.expression.setVariable("TEMPERATURE", ClientFrameTicker.getTemperature());
        }
        if (this.hasDownfall) {
            this.expression.setVariable("DOWNFALL", ClientFrameTicker.getDownfall());
        }
        if (this.hasPlayer) {
            e = class_310.method_1551().method_1560();
            this.expression.setVariable("PLAYER_X", e.method_23317());
            this.expression.setVariable("PLAYER_Y", e.method_23318());
            this.expression.setVariable("PLAYER_Z", e.method_23321());
        }
        if (this.hasDistance) {
            e = class_310.method_1551().method_1560();
            double x = particle.field_3874 - e.method_23317();
            double y = particle.field_3854 - e.method_23318();
            double z = particle.field_3871 - e.method_23321();
            this.expression.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
        }
        if (this.hasPlayerSpeed) {
            this.expression.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
        }
        if (this.hasRenderDistance) {
            this.expression.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
        }
        ExpressionUtils.randomizeRandom();
        return this.expression.evaluate();
    }
}

