/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils.exp;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.polytone.utils.exp.ArrayStack;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Functions;
import net.objecthunter.exp4j.tokenizer.FunctionToken;
import net.objecthunter.exp4j.tokenizer.NumberToken;
import net.objecthunter.exp4j.tokenizer.OperatorToken;
import net.objecthunter.exp4j.tokenizer.Token;
import net.objecthunter.exp4j.tokenizer.VariableToken;

public class ConcurrentExpression {
    private final Token[] tokens;
    private final ThreadLocal<Map<String, Double>> variables;
    private final Set<String> userFunctionNames;
    private static final Field TOKENS_FIELD;
    private static final Field VARIABLES_FIELD;
    private static final Field USER_FUNCTION_NAMES_FIELD;

    public ConcurrentExpression(Expression existing) {
        try {
            this.tokens = (Token[])TOKENS_FIELD.get(existing);
            Map originalVars = (Map)VARIABLES_FIELD.get(existing);
            this.variables = ThreadLocal.withInitial(() -> new HashMap(originalVars));
            this.userFunctionNames = (Set)USER_FUNCTION_NAMES_FIELD.get(existing);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static ConcurrentExpression of(ExpressionBuilder operator) {
        return new ConcurrentExpression(operator.build());
    }

    public ConcurrentExpression setVariable(String name, double value) {
        this.variables.get().put(name, value);
        return this;
    }

    private void checkVariableName(String name) {
        if (this.userFunctionNames.contains(name) || Functions.getBuiltinFunction((String)name) != null) {
            throw new IllegalArgumentException("The variable name '" + name + "' is invalid. Since there exists a function with the same name");
        }
    }

    public ConcurrentExpression setVariables(Map<String, Double> variables) {
        for (Map.Entry<String, Double> v : variables.entrySet()) {
            this.setVariable(v.getKey(), v.getValue());
        }
        return this;
    }

    public Set<String> getVariableNames() {
        HashSet<String> variables = new HashSet<String>();
        for (Token t : this.tokens) {
            if (t.getType() != 6) continue;
            variables.add(((VariableToken)t).getName());
        }
        return variables;
    }

    public double evaluate() {
        ArrayStack output = new ArrayStack();
        for (Token t : this.tokens) {
            if (t.getType() == 1) {
                output.push(((NumberToken)t).getValue());
                continue;
            }
            if (t.getType() == 6) {
                String name = ((VariableToken)t).getName();
                Double value = this.variables.get().get(name);
                if (value == null) {
                    throw new IllegalArgumentException("No value has been set for the setVariable '" + name + "'.");
                }
                output.push(value);
                continue;
            }
            if (t.getType() == 2) {
                OperatorToken op = (OperatorToken)t;
                if (output.size() < op.getOperator().getNumOperands()) {
                    throw new IllegalArgumentException("Invalid number of operands available for '" + op.getOperator().getSymbol() + "' operator");
                }
                if (op.getOperator().getNumOperands() == 2) {
                    double rightArg = output.pop();
                    double leftArg = output.pop();
                    output.push(op.getOperator().apply(new double[]{leftArg, rightArg}));
                    continue;
                }
                if (op.getOperator().getNumOperands() != 1) continue;
                double arg = output.pop();
                output.push(op.getOperator().apply(new double[]{arg}));
                continue;
            }
            if (t.getType() != 3) continue;
            FunctionToken func = (FunctionToken)t;
            int numArguments = func.getFunction().getNumArguments();
            if (output.size() < numArguments) {
                throw new IllegalArgumentException("Invalid number of arguments available for '" + func.getFunction().getName() + "' function");
            }
            double[] args = new double[numArguments];
            for (int j = numArguments - 1; j >= 0; --j) {
                args[j] = output.pop();
            }
            output.push(func.getFunction().apply(args));
        }
        if (output.size() > 1) {
            throw new IllegalArgumentException("Invalid number of items on the output queue. Might be caused by an invalid number of arguments for a function.");
        }
        return output.pop();
    }

    static {
        try {
            TOKENS_FIELD = Expression.class.getDeclaredField("tokens");
            TOKENS_FIELD.setAccessible(true);
            VARIABLES_FIELD = Expression.class.getDeclaredField("variables");
            VARIABLES_FIELD.setAccessible(true);
            USER_FUNCTION_NAMES_FIELD = Expression.class.getDeclaredField("userFunctionNames");
            USER_FUNCTION_NAMES_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

