/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockSetTypeProvider;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockSetType;

public class BlockSetManager
extends JsonPartialReloader {
    private final MapRegistry<BlockSetTypeProvider> blockSetTypes = new MapRegistry("Custom Block Set Types");
    private int counter = 0;

    public BlockSetManager() {
        super("custom_block_sets", "block_sets");
    }

    public String getNextName() {
        return "polytone:custom_" + this.counter++;
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.blockSetTypes.clear();
        this.counter = 0;
    }

    @Override
    protected void parseWithLevel(Map<ResourceLocation, JsonElement> jsons, RegistryOps<JsonElement> ops, RegistryAccess access) {
        BlockSetType.m_271801_().forEach(type -> this.blockSetTypes.register(new ResourceLocation(type.f_271253_()), new BlockSetTypeProvider.Vanilla((BlockSetType)type)));
        for (Map.Entry<ResourceLocation, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            ResourceLocation id = j.getKey();
            BlockSetTypeProvider type2 = (BlockSetTypeProvider)((Pair)BlockSetTypeProvider.CODEC.decode(ops, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Custom Block Set Type with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            this.blockSetTypes.register(id, type2);
        }
    }

    @Override
    protected void applyWithLevel(RegistryAccess access, boolean isLogIn) {
        if (!this.blockSetTypes.isEmpty()) {
            Polytone.LOGGER.info("Registered {} custom block set types", (Object)this.blockSetTypes.size());
        }
    }

    public Codec<BlockSetTypeProvider> byNameCodec() {
        return this.blockSetTypes;
    }
}

