/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.item.IPolytoneItem;
import net.mehvahdjukaar.polytone.item.ItemModifier;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ItemModifiersManager
extends JsonImgPartialReloader {
    private final Map<Item, ItemModifier> modifiers = new HashMap<Item, ItemModifier>();
    private final Map<Item, ItemModifier> vanillaProperties = new HashMap<Item, ItemModifier>();

    public ItemModifiersManager() {
        super("item_modifiers", "item_properties");
    }

    @Override
    protected void parseWithLevel(JsonImgPartialReloader.Resources resources, RegistryOps<JsonElement> ops, RegistryAccess access) {
        Map<ResourceLocation, JsonElement> jsons = resources.jsons();
        HashMap<ResourceLocation, ArrayImage> textures = new HashMap<ResourceLocation, ArrayImage>(resources.textures());
        HashSet<ResourceLocation> usedTextures = new HashSet<ResourceLocation>();
        Parsed.SortedMap<ItemModifier> parsedModifiers = Parsed.batchParseAlways(jsons, ItemModifier.CODEC, ops, "item modifier");
        for (Map.Entry<ResourceLocation, Parsed<ItemModifier>> entry : parsedModifiers.entrySet()) {
            ResourceLocation tintId = entry.getKey();
            Parsed<ItemModifier> result = entry.getValue();
            ItemModifier modifier = result.getResultOrPartial();
            if (!modifier.hasTint() && textures.containsKey(tintId)) {
                modifier = modifier.merge(ItemModifier.ofItemColor(Colormap.createDefTriangle()));
            }
            ResourceLocation barId = tintId.m_266382_("_bar");
            if (!modifier.hasBarColor() && textures.containsKey(barId)) {
                modifier = modifier.merge(ItemModifier.ofBarColor(Colormap.createDamage()));
            }
            ColormapsManager.tryAcceptingTexture(textures, tintId, modifier.getTint(), usedTextures, true);
            ColormapsManager.tryAcceptingTexture(textures, barId, modifier.getBarColor(), usedTextures, true);
            if (!result.isEnabled()) continue;
            this.addModifier(tintId, modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<ResourceLocation, Object> entry : textures.entrySet()) {
            Colormap defaultColormap;
            ResourceLocation id = entry.getKey();
            if (id.m_135815_().endsWith("_bar")) {
                defaultColormap = Colormap.createDamage();
                ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
                this.addModifier(id, ItemModifier.ofBarColor(defaultColormap));
                continue;
            }
            defaultColormap = Colormap.createDefTriangle();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, ItemModifier.ofItemColor(defaultColormap));
        }
    }

    private void addModifier(ResourceLocation id, ItemModifier mod) {
        for (Holder item : mod.targets().compute(id, BuiltInRegistries.f_257033_)) {
            Item i = (Item)item.m_203334_();
            this.modifiers.merge(i, mod, ItemModifier::merge);
        }
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        for (Map.Entry<Item, ItemModifier> e : this.vanillaProperties.entrySet()) {
            e.getValue().apply(e.getKey());
            ((IPolytoneItem)e.getKey()).polytone$setModifier(null);
        }
        this.modifiers.clear();
    }

    @Override
    protected void applyWithLevel(RegistryAccess access, boolean isLogIn) {
        for (Map.Entry<Item, ItemModifier> e : this.modifiers.entrySet()) {
            Item target = e.getKey();
            ItemModifier value = e.getValue();
            this.vanillaProperties.put(target, value.apply(target));
            if (!value.shouldAttachToItem()) continue;
            ((IPolytoneItem)e.getKey()).polytone$setModifier(value);
        }
        if (!this.vanillaProperties.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Item Properties", (Object)this.vanillaProperties.size());
        }
        this.modifiers.clear();
    }
}

