/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.mehvahdjukaar.polytone.particle.CustomParticleType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public record ExtraDataParticleOptions(Map<String, Float> extraData, ParticleType<?> type) implements ParticleOptions
{
    public static final ParticleOptions.Deserializer<ExtraDataParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<ExtraDataParticleOptions>(){

        public ExtraDataParticleOptions fromCommand(ParticleType<ExtraDataParticleOptions> arg, StringReader stringReader) {
            return new ExtraDataParticleOptions(new HashMap<String, Float>(), arg);
        }

        public ExtraDataParticleOptions fromNetwork(ParticleType<ExtraDataParticleOptions> arg, FriendlyByteBuf arg2) {
            int size = arg2.m_130242_();
            Map<String, Float> data = ExtraDataParticleOptions.makeMap().apply(size);
            for (int i = 0; i < size; ++i) {
                String key = arg2.m_130277_();
                float value = arg2.readFloat();
                data.put(key, Float.valueOf(value));
            }
            return new ExtraDataParticleOptions(data, arg);
        }
    };

    public static Codec<ExtraDataParticleOptions> codec(Supplier<ParticleType<ExtraDataParticleOptions>> typeGetter) {
        return Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT).optionalFieldOf("extra_data", Map.of()).xmap(stringFloatMap -> new ExtraDataParticleOptions((Map<String, Float>)stringFloatMap, (ParticleType<?>)((ParticleType)typeGetter.get())), ExtraDataParticleOptions::extraData).codec();
    }

    @NotNull
    private static IntFunction<Map<String, Float>> makeMap() {
        return i -> new HashMap();
    }

    public ParticleType<?> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.extraData.size());
        for (Map.Entry<String, Float> entry : this.extraData.entrySet()) {
            buffer.m_130070_(entry.getKey());
            buffer.writeFloat(entry.getValue().floatValue());
        }
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()));
    }

    public void apply(Particle particle) {
        Float custom;
        Float size;
        Float alpha;
        Float blue;
        Float green;
        Float red;
        if (this.extraData.isEmpty()) {
            return;
        }
        Float rot = this.extraData.get("roll");
        if (rot != null) {
            particle.f_107231_ = rot.floatValue();
            particle.f_107204_ = rot.floatValue();
        }
        if ((red = this.extraData.get("red")) != null) {
            particle.f_107227_ = red.floatValue();
        }
        if ((green = this.extraData.get("green")) != null) {
            particle.f_107228_ = green.floatValue();
        }
        if ((blue = this.extraData.get("blue")) != null) {
            particle.f_107229_ = blue.floatValue();
        }
        if ((alpha = this.extraData.get("alpha")) != null) {
            particle.f_107230_ = alpha.floatValue();
        }
        if ((size = this.extraData.get("size")) != null && particle instanceof SingleQuadParticle) {
            SingleQuadParticle sp = (SingleQuadParticle)particle;
            sp.f_107663_ = size.floatValue();
        }
        if ((custom = this.extraData.get("custom")) != null && particle instanceof CustomParticleType.Instance) {
            CustomParticleType.Instance inst = (CustomParticleType.Instance)particle;
            inst.custom = custom.floatValue();
        }
    }
}

