/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.slotify.BlitModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class GuiOverlayManager
extends JsonPartialReloader {
    private final Map<ResourceLocation, BlitModifier> blitModifiers = new HashMap<ResourceLocation, BlitModifier>();
    private int index = 0;
    private boolean active = false;

    public GuiOverlayManager() {
        super("overlay_modifiers");
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.blitModifiers.clear();
    }

    @Override
    protected void parseWithLevel(Map<ResourceLocation, JsonElement> jsons, RegistryOps<JsonElement> ops, RegistryAccess access) {
        for (Map.Entry<ResourceLocation, BlitModifier> j : Parsed.batchParseOnlyEnabled(jsons, BlitModifier.CODEC, ops, "overlay modifier")) {
            BlitModifier effect = j.getValue();
            ResourceLocation textureId = effect.target();
            if (this.blitModifiers.containsKey(textureId)) {
                Polytone.LOGGER.warn("Overlay Modifier with texture id {} already exists. Overwriting", (Object)textureId);
            }
            this.blitModifiers.put(textureId, effect);
        }
    }

    @Override
    protected void applyWithLevel(RegistryAccess access, boolean isLogIn) {
    }

    @Override
    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resourceManager) {
        return super.prepare(resourceManager);
    }

    public boolean maybeModifyBlit(GuiGraphics gui, TextureAtlasSprite sprite, int x, int y, int offset, int width, int height) {
        if (!this.active || this.blitModifiers.isEmpty()) {
            return false;
        }
        BlitModifier mod = this.blitModifiers.get(sprite.m_245424_().m_246162_());
        if (mod != null) {
            int ind = mod.index();
            if (ind == -1 || ind == this.index) {
                mod.blitModified(gui, sprite, x, x + width, y, y + height, offset);
                return true;
            }
            ++this.index;
        }
        return false;
    }

    public void onStartRenderingOverlay() {
        this.index = 0;
        this.active = true;
    }

    public void onEndRenderingOverlay() {
        this.active = false;
    }
}

