/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.CodecUtil;
import net.mehvahdjukaar.polytone.utils.Utils;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

public record Targets(List<Entry> entries) {
    public static final Targets EMPTY = new Targets(List.of());
    private static final Codec<Entry> SIMPLE_TAG_OR_REGEX_ENTRY_CODEC = CodecUtil.withAlternative(SimpleLocation.SIMPLE_CODEC, CodecUtil.withAlternative(TagLocation.TAG_CODEC, RegexLocation.REGEX_CODEC));
    private static final Codec<Entry> ENTRY_CODEC = CodecUtil.withAlternative(SIMPLE_TAG_OR_REGEX_ENTRY_CODEC, OptionalEntry.OPTIONAL_CODEC);
    public static final Codec<Targets> CODEC = CodecUtil.withAlternative(ENTRY_CODEC.xmap(List::of, l -> (Entry)l.get(0)), ENTRY_CODEC.listOf()).xmap(Targets::new, t -> t.entries);

    public static Targets ofIds(ResourceLocation ... blocks) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (ResourceLocation id : blocks) {
            entries.add(new SimpleLocation(id));
        }
        return new Targets(entries);
    }

    public static Targets ofIds(Set<ResourceLocation> blocks) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (ResourceLocation id : blocks) {
            entries.add(new SimpleLocation(id));
        }
        return new Targets(entries);
    }

    public static Targets ofOptionalIds(Set<ResourceLocation> blocks) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (ResourceLocation id : blocks) {
            entries.add(new OptionalEntry(new SimpleLocation(id), false));
        }
        return new Targets(entries);
    }

    public <T> Collection<Holder<T>> compute(ResourceLocation fileId, Registry<T> registry) {
        HashSet<Holder<T>> set = new HashSet<Holder<T>>();
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)registry.m_123023_(), (ResourceLocation)fileId);
        Optional implicitTarget = registry.m_203636_(key);
        if (!this.entries.isEmpty()) {
            if (implicitTarget.isPresent()) {
                Polytone.LOGGER.warn("Found Polytone file with explicit Targets ({}) also having a valid IMPLICIT (file path) Target ({}). Consider moving it under your OWN namespace to avoid overriding other packs modifiers with the same path", this.entries, (Object)fileId);
            }
            for (Entry entry : this.entries) {
                try {
                    for (Holder<T> holder : entry.get(registry)) {
                        set.add(holder);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to parse some target(s) for polytone file " + String.valueOf(fileId), e);
                }
            }
        } else if (implicitTarget.isPresent()) {
            set.add((Holder)implicitTarget.get());
        } else {
            Polytone.LOGGER.error("Found Polytone file {} with no valid implicit targets and no explicit targets from registry {}", (Object)fileId, registry);
        }
        return set;
    }

    public Targets merge(Targets other) {
        return new Targets(Utils.mergeList(this.entries, other.entries));
    }

    public void addSimple(@NotNull ResourceLocation id) {
        SimpleLocation simpleLocation = new SimpleLocation(id);
        this.entries.add(simpleLocation);
    }

    public void addTag(ResourceLocation id) {
        TagLocation tagLocation = new TagLocation(id);
        this.entries.add(tagLocation);
    }

    private record SimpleLocation(@NotNull ResourceLocation id) implements Entry
    {
        public static final Codec<SimpleLocation> SIMPLE_CODEC = ResourceLocation.f_135803_.xmap(SimpleLocation::new, s -> s.id);

        @Override
        public <T> Iterable<? extends Holder<T>> get(Registry<T> reg) {
            Optional holder = reg.m_203636_(ResourceKey.m_135785_((ResourceKey)reg.m_123023_(), (ResourceLocation)this.id));
            if (holder.isEmpty() && this.id.m_135827_().equals("minecraft")) {
                Polytone.LOGGER.error("Found missing ID in minecraft namespace: {}", (Object)(String.valueOf(this.id) + ". Polytone will skip it but this is remains a bug of the Resource Pack. Optional entries or resource conditions should be used to maintain backward compatibility instead."));
                return List.of();
            }
            return List.of((Holder.Reference)holder.orElseThrow(() -> new IllegalStateException("Entry not found: " + String.valueOf(this.id))));
        }
    }

    private record OptionalEntry(Entry entry, boolean required) implements Entry
    {
        public static final Codec<OptionalEntry> OPTIONAL_CODEC = RecordCodecBuilder.create(i -> i.group((App)SIMPLE_TAG_OR_REGEX_ENTRY_CODEC.fieldOf("id").forGetter(OptionalEntry::entry), (App)Codec.BOOL.optionalFieldOf("required", (Object)true).forGetter(OptionalEntry::required)).apply((Applicative)i, OptionalEntry::new));

        @Override
        public <T> Iterable<? extends Holder<T>> get(Registry<T> reg) {
            try {
                return this.entry.get(reg);
            }
            catch (IllegalStateException e) {
                if (this.required) {
                    throw e;
                }
                return List.of();
            }
        }

        @Override
        public String toString() {
            return "OPT{entry=" + String.valueOf(this.entry) + ", required=" + this.required + "}";
        }
    }

    private static interface Entry {
        public <T> Iterable<? extends Holder<T>> get(Registry<T> var1);
    }

    private record TagLocation(ResourceLocation id) implements Entry
    {
        public static final Codec<TagLocation> TAG_CODEC = Codec.STRING.flatXmap(s -> {
            if (s.startsWith("#")) {
                return ResourceLocation.m_135837_((String)s.substring(1)).map(TagLocation::new);
            }
            return DataResult.error(() -> "Tag location must start with #");
        }, id -> DataResult.success((Object)id.toString()));

        public <T> Iterable<Holder<T>> get(Registry<T> reg) {
            TagKey key = TagKey.m_203882_((ResourceKey)reg.m_123023_(), (ResourceLocation)this.id);
            return (Iterable)reg.m_203431_(key).orElseThrow(() -> new IllegalStateException("Tag not found: " + String.valueOf(this.id)));
        }

        @Override
        public String toString() {
            return "#" + String.valueOf(this.id);
        }
    }

    private record RegexLocation(Pattern regex) implements Entry
    {
        public static final Codec<RegexLocation> REGEX_CODEC = Codec.STRING.xmap(s -> new RegexLocation(Pattern.compile(s)), r -> r.regex.pattern());

        @Override
        public <T> Iterable<? extends Holder<T>> get(Registry<T> reg) {
            return reg.m_203611_().filter(e -> this.regex.matcher(e.m_205785_().m_135782_().toString()).matches()).toList();
        }

        @Override
        public String toString() {
            return "RE: " + this.regex.pattern();
        }
    }
}

