/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.slotify.BlitModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_5455;
import net.minecraft.class_6903;

public class GuiOverlayManager
extends JsonPartialReloader {
    private final Map<class_2960, BlitModifier> blitModifiers = new HashMap<class_2960, BlitModifier>();
    private int index = 0;
    private boolean active = false;

    public GuiOverlayManager() {
        super("overlay_modifiers");
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.blitModifiers.clear();
    }

    @Override
    protected void parseWithLevel(Map<class_2960, JsonElement> jsons, class_6903<JsonElement> ops, class_5455 access) {
        for (Map.Entry<class_2960, BlitModifier> j : Parsed.batchParseOnlyEnabled(jsons, BlitModifier.CODEC, ops, "overlay modifier")) {
            BlitModifier effect = j.getValue();
            class_2960 textureId = effect.target();
            if (this.blitModifiers.containsKey(textureId)) {
                Polytone.LOGGER.warn("Overlay Modifier with texture id {} already exists. Overwriting", (Object)textureId);
            }
            this.blitModifiers.put(textureId, effect);
        }
    }

    @Override
    protected void applyWithLevel(class_5455 access, boolean isLogIn) {
    }

    @Override
    protected Map<class_2960, JsonElement> prepare(class_3300 resourceManager) {
        return super.prepare(resourceManager);
    }

    public boolean maybeModifyBlit(class_332 gui, class_1058 sprite, int x, int y, int offset, int width, int height) {
        if (!this.active || this.blitModifiers.isEmpty()) {
            return false;
        }
        BlitModifier mod = this.blitModifiers.get(sprite.method_45851().method_45816());
        if (mod != null) {
            int ind = mod.index();
            if (ind == -1 || ind == this.index) {
                mod.blitModified(gui, sprite, x, x + width, y, y + height, offset);
                return true;
            }
            ++this.index;
        }
        return false;
    }

    public void onStartRenderingOverlay() {
        this.index = 0;
        this.active = true;
    }

    public void onEndRenderingOverlay() {
        this.active = false;
    }
}

