/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.slotify.IntRange;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.class_1735;
import net.minecraft.class_332;

public record SlotModifier(Optional<IntRange> targets, int color, int color2, int xOffset, int yOffset, int zOffset, Optional<IntRange> targetX, Optional<IntRange> targetY, Optional<String> targetClass) {
    public static final Codec<SlotModifier> CODEC = RecordCodecBuilder.create(i -> i.group((App)StrOpt.of(IntRange.CODEC, "slots").forGetter(SlotModifier::targets), (App)StrOpt.of(ColorUtils.CODEC, "color", -1).forGetter(SlotModifier::color), (App)StrOpt.of(ColorUtils.CODEC, "color_2", -1).forGetter(SlotModifier::color2), (App)StrOpt.of(Codec.INT, "x_offset", 0).forGetter(SlotModifier::xOffset), (App)StrOpt.of(Codec.INT, "y_offset", 0).forGetter(SlotModifier::yOffset), (App)StrOpt.of(Codec.INT, "z_offset", 0).forGetter(SlotModifier::zOffset), (App)StrOpt.of(IntRange.CODEC, "target_x").forGetter(SlotModifier::targetX), (App)StrOpt.of(IntRange.CODEC, "target_y").forGetter(SlotModifier::targetY), (App)StrOpt.of(Codec.STRING.xmap(PlatStuff::maybeRemapName, PlatStuff::maybeRemapName), "target_class_name").forGetter(SlotModifier::targetClass)).apply((Applicative)i, SlotModifier::new));

    public void modify(class_1735 slot) {
        slot.field_7873 += this.xOffset;
        slot.field_7872 += this.yOffset;
    }

    public boolean matches(class_1735 slot) {
        if (this.targets.isPresent() && !this.targets.get().has(slot.field_7874)) {
            return false;
        }
        if (this.targetX.isPresent() && this.targetX.get().has(slot.field_7873)) {
            return false;
        }
        if (this.targetY.isPresent() && this.targetY.get().has(slot.field_7872)) {
            return false;
        }
        if (this.targetClass.isPresent()) {
            String name = this.targetClass.get();
            if (!slot.getClass().getSimpleName().equals(name) && !slot.getClass().getName().equals(name)) {
                return false;
            }
        }
        return true;
    }

    public boolean hasCustomColor() {
        return this.color != -1 || this.color2 != -1 || this.zOffset != 0;
    }

    public void renderCustomHighlight(class_332 graphics, int x, int y, int offset) {
        int c1 = this.color;
        int c2 = this.color2 == -1 ? this.color : this.color2;
        SlotModifier.renderSlotHighlight(graphics, x, y, c1, c2, offset + this.zOffset);
    }

    public static void renderSlotHighlight(class_332 graphics, int x, int y, int slotColor, int slotColor2, int offset) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        graphics.method_33284(x, y, x + 16, y + 16, slotColor, slotColor2, offset);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    public boolean hasOffset() {
        return this.xOffset != 0 || this.yOffset != 0;
    }
}

