/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.colormap.IndexCompoundColorGetter;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.mehvahdjukaar.polytone.utils.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_325;
import net.minecraft.class_326;
import net.minecraft.class_3542;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;

public record ItemModifier(Optional<? extends class_326> tintGetter, Optional<IColorGetter> barColor, Optional<Rarity> rarity, List<class_2561> tooltips, List<Pattern> removedTooltips, Targets targets) {
    public static final Codec<ItemModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(IndexCompoundColorGetter.SINGLE_OR_MULTIPLE, "colormap").forGetter(b -> b.tintGetter), (App)StrOpt.of(Colormap.CODEC, "bar_color").forGetter(ItemModifier::barColor), (App)StrOpt.of(class_3542.method_28140(Rarity::values), "rarity").forGetter(ItemModifier::rarity), (App)StrOpt.of(class_5699.field_40722.listOf(), "tooltips", List.of()).forGetter(ItemModifier::tooltips), (App)StrOpt.of(class_5699.field_37408.listOf(), "removed_tooltips", List.of()).forGetter(ItemModifier::removedTooltips), (App)Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).forGetter(ItemModifier::targets)).apply((Applicative)instance, ItemModifier::new));

    public static ItemModifier ofItemColor(Colormap colormap) {
        return new ItemModifier(Optional.of(colormap), Optional.empty(), Optional.empty(), List.of(), List.of(), Targets.EMPTY);
    }

    public static ItemModifier ofBarColor(Colormap colormap) {
        return new ItemModifier(Optional.empty(), Optional.of(colormap), Optional.empty(), List.of(), List.of(), Targets.EMPTY);
    }

    public ItemModifier merge(ItemModifier newMod) {
        return new ItemModifier(newMod.tintGetter.isPresent() ? newMod.tintGetter : this.tintGetter, newMod.barColor.isPresent() ? newMod.barColor : this.barColor, newMod.rarity.isPresent() ? newMod.rarity : this.rarity, Utils.mergeList(newMod.tooltips, this.tooltips), Utils.mergeList(newMod.removedTooltips, this.removedTooltips), newMod.targets.merge(this.targets));
    }

    public ItemModifier apply(class_1792 item) {
        class_1814 oldRarity = null;
        if (this.rarity.isPresent()) {
            oldRarity = item.method_7862(item.method_7854());
            item.field_8009 = this.rarity.get().toVanilla();
        }
        class_326 oldColor = null;
        if (this.tintGetter.isPresent()) {
            class_325 itemColors = class_310.method_1551().field_1760;
            oldColor = PlatStuff.getItemColor(itemColors, item);
            itemColors.method_1708(this.tintGetter.get(), new class_1935[]{item});
        }
        return new ItemModifier(Optional.ofNullable(oldColor), Optional.empty(), Optional.ofNullable(Rarity.fromVanilla(oldRarity)), List.of(), List.of(), Targets.EMPTY);
    }

    @Nullable
    public Integer getBarColor(class_1799 itemStack) {
        return this.barColor.map(c -> c.getColor(itemStack, 0)).orElse(null);
    }

    public boolean hasTint() {
        return this.tintGetter.isPresent();
    }

    public class_326 getTint() {
        return this.tintGetter.orElse(null);
    }

    public class_326 getBarColor() {
        return this.barColor.orElse(null);
    }

    public boolean hasBarColor() {
        return this.barColor.isPresent();
    }

    public void modifyTooltips(List<class_2561> tooltips) {
        tooltips.removeIf(t -> this.removedTooltips.stream().anyMatch(p -> p.matcher(t.getString()).matches()));
        tooltips.addAll(this.tooltips);
    }

    public boolean shouldAttachToItem() {
        return !this.tooltips.isEmpty() || !this.removedTooltips.isEmpty() || this.barColor.isPresent();
    }

    public static enum Rarity implements class_3542
    {
        COMMON,
        UNCOMMON,
        RARE,
        EPIC;


        public static Rarity fromVanilla(class_1814 oldRarity) {
            if (oldRarity == null) {
                return null;
            }
            return switch (oldRarity) {
                default -> throw new IncompatibleClassChangeError();
                case class_1814.field_8906 -> COMMON;
                case class_1814.field_8907 -> UNCOMMON;
                case class_1814.field_8903 -> RARE;
                case class_1814.field_8904 -> EPIC;
            };
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public class_1814 toVanilla() {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> class_1814.field_8906;
                case 1 -> class_1814.field_8907;
                case 2 -> class_1814.field_8903;
                case 3 -> class_1814.field_8904;
            };
        }
    }
}

