/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeEffectModifier;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.CodecUtil;
import net.mehvahdjukaar.polytone.utils.Weather;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_758;
import org.jetbrains.annotations.Nullable;

public class FogManager {
    private static final FogState ONE = new FogState(1.0f, 1.0f);
    private static final FogStateMutable lastBiomeFog = new FogStateMutable();
    private static final FogStateMutable lastLiquidFog = new FogStateMutable();

    @Nullable
    public static FogState modifyBiomeFog(float originalNearPlane, float originalFarPlane) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return null;
        }
        class_1937 level = player.method_37908();
        if (class_758.method_42588((class_1297)player, (float)mc.method_1534()) != null) {
            return null;
        }
        class_6880 biome = level.method_23753(player.method_24515());
        BiomeEffectModifier fogMod = Polytone.BIOME_MODIFIERS.getFogModifier((class_1959)biome.comp_349());
        FogParam fogRadius = null;
        FogParam fogFade = null;
        if (fogMod != null) {
            fogRadius = fogMod.fogRadius().orElse(null);
            fogFade = fogMod.fogFade().orElse(null);
        }
        return FogManager.modifyFogParameters(level, originalNearPlane, originalFarPlane, fogRadius, fogFade, lastBiomeFog);
    }

    @Nullable
    public static FogState modifyFluidFog(float originalNearPlane, float originalFarPlane, @Nullable FogParam fogRadius, @Nullable FogParam fogFade) {
        return FogManager.modifyFogParameters((class_1937)class_310.method_1551().field_1687, originalNearPlane, originalFarPlane, fogRadius, fogFade, lastLiquidFog);
    }

    @Nullable
    private static FogState modifyFogParameters(@Nullable class_1937 level, float originalNearPlane, float originalFarPlane, @Nullable FogParam fogRadius, @Nullable FogParam fogFade, FogStateMutable old) {
        if (level == null) {
            return null;
        }
        Float radiusMult = null;
        Float fadeMul = null;
        if (fogRadius != null || fogFade != null) {
            radiusMult = Float.valueOf(fogRadius != null ? fogRadius.get(level) : 1.0f);
            fadeMul = Float.valueOf(fogFade != null ? fogFade.get(level) : 1.0f);
        }
        if (radiusMult == null && (class_3532.method_15379((float)(old.distanceMult - 1.0f)) > 0.02f || class_3532.method_15379((float)(old.endMult - 1.0f)) > 0.02f)) {
            radiusMult = Float.valueOf(1.0f);
            fadeMul = Float.valueOf(1.0f);
        }
        if (radiusMult != null) {
            float deltaTime = ClientFrameTicker.getDeltaTime();
            float interpolationFactor = deltaTime * 0.1f;
            old.distanceMult = class_3532.method_16439((float)interpolationFactor, (float)old.distanceMult, (float)fadeMul.floatValue());
            old.endMult = class_3532.method_16439((float)interpolationFactor, (float)old.endMult, (float)radiusMult.floatValue());
            float distance = originalFarPlane - originalNearPlane;
            return new FogState((originalFarPlane - distance * old.distanceMult) * old.endMult, originalFarPlane * old.endMult);
        }
        return null;
    }

    public static interface FogParam {
        public static final Codec<FogParam> SIMPLE_CODEC = Codec.FLOAT.xmap(f -> l -> f.floatValue(), fogParam -> Float.valueOf(fogParam.get(null)));
        public static final Codec<FogParam> CODEC = CodecUtil.withAlternative(CodecUtil.withAlternative(SIMPLE_CODEC, Codec.simpleMap(Weather.CODEC, SIMPLE_CODEC, (Keyable)class_3542.method_28142((class_3542[])Weather.values())).xmap(FogMap::new, FogMap::map).codec()), BlockContextExpression.CODEC.xmap(FogExpression::new, fogMap -> fogMap.map));

        public float get(class_1937 var1);
    }

    private static class FogStateMutable {
        private float distanceMult = 1.0f;
        private float endMult = 1.0f;

        private FogStateMutable() {
        }
    }

    public record FogState(float start, float end) {
    }

    public record FogMap(Map<Weather, FogParam> map) implements FogParam
    {
        @Override
        public float get(class_1937 level) {
            Weather w = Weather.get(level);
            return this.map.getOrDefault((Object)w, l -> 1.0f).get(level);
        }
    }

    public record FogExpression(BlockContextExpression map) implements FogParam
    {
        @Override
        public float get(class_1937 level) {
            class_2338 pos = ClientFrameTicker.getCameraPos();
            return (float)this.map.getValue(level, pos, class_2246.field_10124.method_9564());
        }
    }
}

