/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.PolytoneRenderTypes;
import net.mehvahdjukaar.polytone.SpecialModelsHandler;
import net.mehvahdjukaar.polytone.compat.CompatHandler;
import net.mehvahdjukaar.polytone.compat.IrisCompat;
import net.mehvahdjukaar.polytone.content.biome.BiomeEffectsManager;
import net.mehvahdjukaar.polytone.content.biome.BiomeIdMapperManager;
import net.mehvahdjukaar.polytone.content.biome.BiomeKeysCache;
import net.mehvahdjukaar.polytone.content.block.BlockPropertiesManager;
import net.mehvahdjukaar.polytone.content.block.BlockSetManager;
import net.mehvahdjukaar.polytone.content.color.ColorManager;
import net.mehvahdjukaar.polytone.content.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.content.dimension.DimensionEffectsManager;
import net.mehvahdjukaar.polytone.content.entity.EntityModifiersManager;
import net.mehvahdjukaar.polytone.content.fluid.FluidPropertiesManager;
import net.mehvahdjukaar.polytone.content.item.CustomItemModelsManager;
import net.mehvahdjukaar.polytone.content.item.ItemModifiersManager;
import net.mehvahdjukaar.polytone.content.lightmap.LightmapsManager;
import net.mehvahdjukaar.polytone.content.noise.NoiseManager;
import net.mehvahdjukaar.polytone.content.particle.CustomParticlesManager;
import net.mehvahdjukaar.polytone.content.particle.ParticleModifiersManager;
import net.mehvahdjukaar.polytone.content.slotify.GuiModifierManager;
import net.mehvahdjukaar.polytone.content.slotify.GuiOverlayManager;
import net.mehvahdjukaar.polytone.content.sound.SoundTypesManager;
import net.mehvahdjukaar.polytone.content.tabs.CreativeTabsModifiersManager;
import net.mehvahdjukaar.polytone.misc.reloader.CompoundReloader;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;

public class Polytone {
    public static final String MOD_ID = "polytone";
    public static final Logger LOGGER = LogManager.getLogger((String)"Polytone");
    private static CompoundReloader COMPOUND_RELOADER;
    public static final BlockPropertiesManager BLOCK_MODIFIERS;
    public static final FluidPropertiesManager FLUID_MODIFIERS;
    public static final ItemModifiersManager ITEM_MODIFIERS;
    public static final CustomItemModelsManager ITEM_MODELS;
    public static final BiomeEffectsManager BIOME_MODIFIERS;
    public static final NoiseManager NOISES;
    public static final ColormapsManager COLORMAPS;
    public static final LightmapsManager LIGHTMAPS;
    public static final BiomeIdMapperManager BIOME_ID_MAPPERS;
    public static final DimensionEffectsManager DIMENSION_MODIFIERS;
    public static final CustomParticlesManager CUSTOM_PARTICLES;
    public static final ParticleModifiersManager PARTICLE_MODIFIERS;
    public static final EntityModifiersManager ENTITY_MODIFIERS;
    public static final SoundTypesManager SOUND_TYPES;
    public static final ColorManager COLORS;
    public static final GuiModifierManager SLOTIFY;
    public static final GuiOverlayManager OVERLAY_MODIFIERS;
    public static final BlockSetManager BLOCK_SET;
    public static final CreativeTabsModifiersManager CREATIVE_TABS_MODIFIERS;
    private static final Future<Set<class_2960>> FUTURE_IDS;
    public static boolean iMessedUp;
    public static boolean isDevEnv;
    public static boolean isForge;

    public static void init(boolean devEnv, boolean forge) {
        COMPOUND_RELOADER = new CompoundReloader(NOISES, SOUND_TYPES, BIOME_ID_MAPPERS, COLORMAPS, CUSTOM_PARTICLES, COLORS, BLOCK_SET, BLOCK_MODIFIERS, FLUID_MODIFIERS, ITEM_MODIFIERS, ITEM_MODELS, BIOME_MODIFIERS, DIMENSION_MODIFIERS, PARTICLE_MODIFIERS, SLOTIFY, OVERLAY_MODIFIERS, ENTITY_MODIFIERS, CREATIVE_TABS_MODIFIERS);
        PlatStuff.addClientReloadListener(() -> COMPOUND_RELOADER, Polytone.res("polytone_stuff"));
        isDevEnv = devEnv;
        isForge = forge;
        PolytoneRenderTypes.init();
        if (CompatHandler.IRIS) {
            IrisCompat.init();
        }
    }

    public static class_2960 res(String name) {
        return class_2960.method_60655((String)MOD_ID, (String)name);
    }

    public static void onTagsReceived(class_7225.class_7874 registryAccess) {
        try {
            if (isDevEnv) {
                Polytone.scanAllRegistries(registryAccess);
            }
            COMPOUND_RELOADER.applyWithLevel(registryAccess, false);
            BiomeKeysCache.clear();
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to apply some Polytone modifiers on world load", (Throwable)e);
            class_374 toastComponent = class_310.method_1551().method_1566();
            class_370.method_1990((class_374)toastComponent, (class_370.class_9037)class_370.class_9037.field_47585, (class_2561)class_2561.method_43471((String)"toast.polytone.lazy_load_fail"), (class_2561)class_2561.method_43471((String)"toast.polytone.load_fail"));
        }
    }

    public static void onLogOut() {
        COMPOUND_RELOADER.resetWithLevel(true);
        BiomeKeysCache.clear();
    }

    public static void onEarlyPackLoad(class_3300 manager) {
        SpecialModelsHandler.clear();
        COMPOUND_RELOADER.earlyProcess(new class_3302.class_11558(manager));
    }

    public static void logException(Exception e, String message) {
        String logDir = Polytone.getLog4jDirectory().orElse(Paths.get("logs", new String[0]).toAbsolutePath().toString());
        String logFilePath = Paths.get(logDir, "polytone.log").toString();
        try (PrintWriter writer = new PrintWriter(new FileWriter(logFilePath, false));){
            writer.println("Polytone version: " + PlatStuff.getVersion());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String timestamp = LocalDateTime.now().format(formatter);
            writer.println("[" + timestamp + "] " + message + ". Check lines below to see where the error was:");
            e.printStackTrace(writer);
        }
        catch (IOException ioException) {
            LOGGER.error("Failed to log onto polytone.log", (Throwable)ioException);
        }
    }

    private static Optional<String> getLog4jDirectory() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        return config.getAppenders().values().stream().filter(appender -> appender instanceof FileAppender).map(appender -> ((FileAppender)appender).getFileName()).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::getParent).map(Path::toString).findFirst();
    }

    public static boolean isEntryDynamic(class_2378<?> reg, class_2960 entryId) {
        if (reg == class_7923.field_44687) {
            return CREATIVE_TABS_MODIFIERS.isDynamicTab(entryId);
        }
        if (reg == class_7923.field_41180) {
            return CUSTOM_PARTICLES.isDynamicParticle(entryId);
        }
        if (reg == class_7923.field_41172) {
            return SOUND_TYPES.isDynamicSound(entryId);
        }
        return false;
    }

    public static boolean isFutureId(class_2960 id) {
        try {
            boolean isFuture = FUTURE_IDS.get().contains(id);
            if (isFuture) {
                LOGGER.error("Found an ID from a future Minecraft version ({}). Polytone will skip it but this is remains a bug of the Resource Pack. Optional entries or resource conditions should be used to maintain backward compatibility instead", (Object)id);
            }
            return isFuture;
        }
        catch (Exception e) {
            LOGGER.error("Failed to check if ID is from a future version", (Throwable)e);
            return false;
        }
    }

    private static void scanAllRegistries(class_7225.class_7874 provider) {
        List<class_5321> regs = List.of(class_7924.field_41225, class_7924.field_41236, class_7924.field_41254, class_7924.field_41197, class_7924.field_46592, class_7924.field_41210, class_7924.field_41270, class_7924.field_41215, class_7924.field_41208);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("registry_dump.txt"));){
            for (class_5321 v : regs) {
                class_7225.class_7226 reg = provider.method_46762(v);
                for (class_6880.class_6883 e : reg.method_42017().toList()) {
                    writer.write(e.method_55840());
                    writer.newLine();
                }
            }
            System.out.println("File written successfully!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Set<class_2960> loadFutureIds() {
        InputStream res = Polytone.class.getClassLoader().getResourceAsStream("future_ids.txt");
        HashSet<class_2960> futureIds = new HashSet<class_2960>();
        if (res != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(res));){
                String line;
                while ((line = reader.readLine()) != null) {
                    class_2960 id = class_2960.method_12829((String)line);
                    if (id != null) {
                        futureIds.add(id);
                        continue;
                    }
                    LOGGER.warn("Invalid ResourceLocation in future_ids.txt: {}", (Object)line);
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to read future_ids.txt", (Throwable)e);
            }
        }
        return futureIds;
    }

    static {
        BLOCK_MODIFIERS = new BlockPropertiesManager();
        FLUID_MODIFIERS = new FluidPropertiesManager();
        ITEM_MODIFIERS = new ItemModifiersManager();
        ITEM_MODELS = new CustomItemModelsManager();
        BIOME_MODIFIERS = new BiomeEffectsManager();
        NOISES = new NoiseManager();
        COLORMAPS = new ColormapsManager();
        LIGHTMAPS = new LightmapsManager();
        BIOME_ID_MAPPERS = new BiomeIdMapperManager();
        DIMENSION_MODIFIERS = new DimensionEffectsManager();
        CUSTOM_PARTICLES = new CustomParticlesManager();
        PARTICLE_MODIFIERS = new ParticleModifiersManager();
        ENTITY_MODIFIERS = new EntityModifiersManager();
        SOUND_TYPES = new SoundTypesManager();
        COLORS = new ColorManager();
        SLOTIFY = new GuiModifierManager();
        OVERLAY_MODIFIERS = new GuiOverlayManager();
        BLOCK_SET = new BlockSetManager();
        CREATIVE_TABS_MODIFIERS = new CreativeTabsModifiersManager();
        FUTURE_IDS = CompletableFuture.supplyAsync(Polytone::loadFutureIds);
        iMessedUp = false;
        isDevEnv = false;
        isForge = false;
    }
}

