/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.biome;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.content.biome.BiomeEffectModifier;
import net.mehvahdjukaar.polytone.misc.ClientFrameTicker;
import net.mehvahdjukaar.polytone.misc.Parsed;
import net.mehvahdjukaar.polytone.misc.reloader.JsonPartialReloader;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4763;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class BiomeEffectsManager
extends JsonPartialReloader {
    private final Map<class_5321<class_1959>, class_4763> vanillaEffects = new HashMap<class_5321<class_1959>, class_4763>();
    private final Map<class_5321<class_1959>, BiomeEffectModifier> effectsToApply = new HashMap<class_5321<class_1959>, BiomeEffectModifier>();
    private boolean needsDynamicApplication = true;
    private final Map<class_1959, BiomeEffectModifier> fogParametersModifiers = new HashMap<class_1959, BiomeEffectModifier>();
    private static float lastFogDistanceMult = 1.0f;
    private static float lastFogEndMult = 1.0f;

    public BiomeEffectsManager() {
        super("biome_modifiers", "biome_effects");
    }

    @Override
    public void parseWithLevel(Map<class_2960, JsonElement> jsons, class_6903<JsonElement> ops, class_7225.class_7874 access) {
        for (Map.Entry<class_2960, BiomeEffectModifier> v : Parsed.batchParseOnlyEnabled(jsons, BiomeEffectModifier.CODEC, ops, "biome modifier")) {
            this.addEffect(v.getKey(), v.getValue(), access);
        }
    }

    private void addEffect(class_2960 pathId, BiomeEffectModifier mod, class_7225.class_7874 access) {
        class_7225.class_7226 registry = access.method_46762(class_7924.field_41236);
        for (class_6880 biome : mod.targets().compute(pathId, registry)) {
            this.effectsToApply.merge((class_5321<class_1959>)((class_5321)biome.method_40230().get()), mod, BiomeEffectModifier::merge);
        }
    }

    @Override
    public void applyWithLevel(class_7225.class_7874 registryAccess, boolean isLogIn) {
        if (!isLogIn && !this.needsDynamicApplication) {
            return;
        }
        this.needsDynamicApplication = false;
        if (isLogIn) {
            this.vanillaEffects.clear();
        }
        class_7225.class_7226 biomeReg = registryAccess.method_46762(class_7924.field_41236);
        for (Map.Entry<class_5321<class_1959>, BiomeEffectModifier> v : this.effectsToApply.entrySet()) {
            class_5321<class_1959> biomeId = v.getKey();
            BiomeEffectModifier modifier = v.getValue();
            Optional biome = biomeReg.method_46746(biomeId);
            if (!biome.isPresent()) continue;
            class_4763 old = modifier.apply((class_1959)((class_6880.class_6883)biome.get()).comp_349());
            this.vanillaEffects.put(biomeId, old);
            if (!modifier.modifyFogParameter()) continue;
            this.fogParametersModifiers.put((class_1959)((class_6880.class_6883)biome.get()).comp_349(), modifier);
        }
        if (!this.vanillaEffects.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Biome Effects Properties", (Object)this.vanillaEffects.size());
        }
    }

    @Override
    public void resetWithLevel(boolean isLogOff) {
        this.needsDynamicApplication = true;
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            class_2378 biomeReg = level.method_30349().method_30530(class_7924.field_41236);
            for (Map.Entry<class_5321<class_1959>, class_4763> v : this.vanillaEffects.entrySet()) {
                Optional biome = biomeReg.method_31189(v.getKey());
                biome.ifPresent(bio -> BiomeEffectModifier.applyEffects(bio, (class_4763)v.getValue()));
            }
        }
        this.vanillaEffects.clear();
        this.effectsToApply.clear();
        this.fogParametersModifiers.clear();
    }

    @Nullable
    public class_241 modifyFogParameters(float originalNearPlane, float originalFarPlane) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return null;
        }
        class_1937 level = player.method_73183();
        class_6880 biome = level.method_23753(player.method_24515());
        BiomeEffectModifier fogMod = this.fogParametersModifiers.get(biome.comp_349());
        class_241 fogScalars = null;
        if (fogMod != null) {
            fogScalars = fogMod.modifyFogParameters(level);
        }
        if (fogScalars == null && (class_3532.method_15379((float)(lastFogDistanceMult - 1.0f)) > 0.02f || class_3532.method_15379((float)(lastFogEndMult - 1.0f)) > 0.02f)) {
            fogScalars = new class_241(1.0f, 1.0f);
        }
        if (fogScalars != null) {
            float deltaTime = ClientFrameTicker.getDeltaTime();
            float interpolationFactor = deltaTime * 0.1f;
            lastFogDistanceMult = class_3532.method_16439((float)interpolationFactor, (float)lastFogDistanceMult, (float)fogScalars.field_1343);
            lastFogEndMult = class_3532.method_16439((float)interpolationFactor, (float)lastFogEndMult, (float)fogScalars.field_1342);
            float distance = originalFarPlane - originalNearPlane;
            return new class_241((originalFarPlane - distance * lastFogDistanceMult) * lastFogEndMult, originalFarPlane * lastFogEndMult);
        }
        return null;
    }
}

