/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.block;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.content.block.BlockSetTypeProvider;
import net.mehvahdjukaar.polytone.misc.reloader.JsonPartialReloader;
import net.mehvahdjukaar.polytone.misc.struc.MapRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_8177;

public class BlockSetManager
extends JsonPartialReloader {
    private final MapRegistry<BlockSetTypeProvider> blockSetTypes = new MapRegistry("Custom Block Set Types");
    private int counter = 0;

    public BlockSetManager() {
        super("custom_block_sets", "block_sets");
    }

    public String getNextName() {
        return "polytone:custom_" + this.counter++;
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.blockSetTypes.clear();
        this.counter = 0;
    }

    @Override
    protected void parseWithLevel(Map<class_2960, JsonElement> jsons, class_6903<JsonElement> ops, class_7225.class_7874 access) {
        class_8177.method_49232().forEach(type -> this.blockSetTypes.register(class_2960.method_60654((String)type.comp_1289()), new BlockSetTypeProvider.Vanilla((class_8177)type)));
        for (Map.Entry<class_2960, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            class_2960 id = j.getKey();
            BlockSetTypeProvider type2 = (BlockSetTypeProvider)((Pair)BlockSetTypeProvider.CODEC.decode(ops, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Custom Block Set Type with json id " + String.valueOf(id) + " - error: " + errorMsg))).getFirst();
            this.blockSetTypes.register(id, type2);
        }
    }

    @Override
    protected void applyWithLevel(class_7225.class_7874 access, boolean isLogIn) {
        if (!this.blockSetTypes.isEmpty()) {
            Polytone.LOGGER.info("Registered {} custom block set types", (Object)this.blockSetTypes.size());
        }
    }

    public Codec<BlockSetTypeProvider> byNameCodec() {
        return this.blockSetTypes;
    }
}

